/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.processor.SetPropertyProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

class SetPropertyReifier extends ExpressionReifier<SetPropertyDefinition> {

    SetPropertyReifier(ProcessorDefinition<?> definition) {
        super((SetPropertyDefinition) definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(definition.getPropertyName(), "propertyName", this);
        Expression expr = definition.getExpression().createExpression(routeContext);
        Expression nameExpr = ExpressionBuilder.parseSimpleOrFallbackToConstantExpression(definition.getPropertyName(), routeContext.getCamelContext());
        return new SetPropertyProcessor(nameExpr, expr);
    }
}
