/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.google.sheets.stream;

import org.apache.camel.CamelContext;
import org.apache.camel.component.google.sheets.AbstractGoogleSheetsTestSupport;
import org.apache.camel.support.PropertyBindingSupport;

/**
 * Abstract base class for GoogleSheets Integration tests generated by Camel API
 * component maven plugin.
 */
public class AbstractGoogleSheetsStreamTestSupport extends AbstractGoogleSheetsTestSupport {

    @Override
    protected CamelContext createCamelContext() throws Exception {

        final CamelContext context = super.createCamelContext();

        final GoogleSheetsStreamConfiguration configuration = new GoogleSheetsStreamConfiguration();
        PropertyBindingSupport.bindProperties(context, configuration, getTestOptions());

        // add GoogleSheetsComponent to Camel context
        final GoogleSheetsStreamComponent component = new GoogleSheetsStreamComponent(context);
        component.setConfiguration(configuration);
        context.addComponent("google-sheets-stream", component);

        return context;
    }
}
