/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public class MongoDBSpanDecorator
extends AbstractSpanDecorator {
    @Override
    public String getComponent() {
        return "mongodb";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = MongoDBSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String opName = queryParameters.get("operation");
        if (opName != null) {
            return opName;
        }
        return super.getOperationName(exchange, endpoint);
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag(Tags.DB_TYPE.getKey(), this.getComponent());
        Map<String, String> queryParameters = MongoDBSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String database = queryParameters.get("database");
        if (database != null) {
            span.setTag(Tags.DB_INSTANCE.getKey(), database);
        }
        span.setTag(Tags.DB_STATEMENT.getKey(), queryParameters.toString());
    }
}

