/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public class CqlSpanDecorator
extends AbstractSpanDecorator {
    public static final String CASSANDRA_DB_TYPE = "cassandra";
    protected static final String CAMEL_CQL_QUERY = "CamelCqlQuery";

    @Override
    public String getComponent() {
        return "cql";
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        Object cql;
        super.pre(span, exchange, endpoint);
        span.setTag(Tags.DB_TYPE.getKey(), CASSANDRA_DB_TYPE);
        URI uri = URI.create(endpoint.getEndpointUri());
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            span.setTag(Tags.DB_INSTANCE.getKey(), uri.getPath().substring(1));
        }
        if ((cql = exchange.getIn().getHeader(CAMEL_CQL_QUERY)) != null) {
            span.setTag(Tags.DB_STATEMENT.getKey(), cql.toString());
        } else {
            Map<String, String> queryParameters = CqlSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            if (queryParameters.containsKey("cql")) {
                span.setTag(Tags.DB_STATEMENT.getKey(), queryParameters.get("cql"));
            }
        }
    }
}

