/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelPropertiesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextHelper.class);

    private CamelPropertiesHelper() {
    }

    public static boolean setCamelProperties(CamelContext context, Object target, Map<String, Object> properties, boolean failIfNotSet) throws Exception {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : null;
            boolean hit = false;
            if (stringValue != null && EndpointHelper.isReferenceParameter((String)stringValue)) {
                hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, null, (String)stringValue, (boolean)true);
            } else if (value != null) {
                try {
                    hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, (Object)value);
                }
                catch (IllegalArgumentException e) {
                    hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, null, (String)stringValue, (boolean)true);
                }
            }
            if (hit) {
                it.remove();
                rc = true;
                continue;
            }
            if (!failIfNotSet) continue;
            throw new IllegalArgumentException("Cannot configure option [" + name + "] with value [" + stringValue + "] as the bean class [" + ObjectHelper.classCanonicalName((Object)target) + "] has no suitable setter method, or not possible to lookup a bean with the id [" + stringValue + "] in Spring Boot registry");
        }
        return rc;
    }

    public static void resolvePropertyPlaceholders(CamelContext camelContext, Object target) throws Exception {
        LOG.trace("Resolving property placeholders for: {}", target);
        HashMap properties = new HashMap();
        IntrospectionSupport.getProperties((Object)target, properties, null);
        HashMap changedProperties = new HashMap();
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), target);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String text = (String)value;
                if ((text = camelContext.resolvePropertyPlaceholders(text)) == value) continue;
                boolean changed = IntrospectionSupport.setProperty((TypeConverter)camelContext.getTypeConverter(), (Object)target, (String)name, (Object)text);
                if (!changed) {
                    throw new IllegalArgumentException("No setter to set property: " + name + " to: " + text + " on: " + target);
                }
                changedProperties.put(name, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, text});
            }
        }
    }
}

