/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TypeConverters;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckService;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.FileWatcherReloadStrategy;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.FilePropertySource;
import org.apache.camel.spring.boot.RoutesCollector;
import org.apache.camel.spring.boot.SpringBootXmlCamelContextConfigurer;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.XmlCamelContextConfigurer;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
public class CamelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoConfiguration.class);

    @Bean(name={"xmlCamelContextConfigurer"})
    XmlCamelContextConfigurer springBootCamelContextConfigurer() {
        return new SpringBootXmlCamelContextConfigurer();
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config) throws Exception {
        SpringCamelContext camelContext = new SpringCamelContext(applicationContext);
        return CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config);
    }

    static CamelContext doConfigureCamelContext(ApplicationContext applicationContext, CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        MutablePropertySources sources;
        Environment env;
        camelContext.init();
        if (camelContext instanceof DefaultCamelContext) {
            DefaultCamelContext defaultContext = (DefaultCamelContext)camelContext;
            Map repositories = applicationContext.getBeansOfType(BeanRepository.class);
            if (!repositories.isEmpty()) {
                ArrayList<Object> reps = new ArrayList<Object>();
                reps.add(new ApplicationContextBeanRepository(applicationContext));
                reps.addAll(repositories.values());
                OrderComparator.sort(reps);
                defaultContext.setRegistry((Registry)new DefaultRegistry(reps));
            }
        }
        if (ObjectHelper.isNotEmpty((Object)config.getFileConfigurations()) && (env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && (sources = ((ConfigurableEnvironment)env).getPropertySources()) != null && !sources.contains("camel-file-configuration")) {
            sources.addFirst((PropertySource)new FilePropertySource("camel-file-configuration", applicationContext, config.getFileConfigurations()));
        }
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ((SpringCamelContext)camelContext).setName(config.getName());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout((long)config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCachingEnabled()));
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolChiper(config.getStreamCachingSpoolChiper());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        camelContext.setMessageHistory(Boolean.valueOf(config.isMessageHistory()));
        camelContext.setLogMask(Boolean.valueOf(config.isLogMask()));
        camelContext.setLogExhaustedMessageBody(Boolean.valueOf(config.isLogExhaustedMessageBody()));
        camelContext.setHandleFault(Boolean.valueOf(config.isHandleFault()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        camelContext.setUseBreadcrumb(Boolean.valueOf(config.isUseBreadcrumb()));
        camelContext.setUseDataType(Boolean.valueOf(config.isUseDataType()));
        camelContext.setUseMDCLogging(Boolean.valueOf(config.isUseMdcLogging()));
        camelContext.setLoadTypeConverters(Boolean.valueOf(config.isLoadTypeConverters()));
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setCreateConnector(Boolean.valueOf(config.isJmxCreateConnector()));
        }
        camelContext.setPackageScanClassResolver((PackageScanClassResolver)new FatJarPackageScanClassResolver());
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        if (config.getXmlRoutesReloadDirectory() != null) {
            FileWatcherReloadStrategy reload = new FileWatcherReloadStrategy(config.getXmlRoutesReloadDirectory());
            camelContext.setReloadStrategy((ReloadStrategy)reload);
        }
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        CamelAutoConfiguration.afterPropertiesSet(applicationContext, camelContext);
        return camelContext;
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new RoutesCollector(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config);
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={FluentProducerTemplate.class})
    @Lazy
    FluentProducerTemplate fluentProducerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        FluentProducerTemplate fluentProducerTemplate = camelContext.createFluentProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)fluentProducerTemplate);
        return fluentProducerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    @Lazy
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)producerTemplate);
        return producerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    @Lazy
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ConsumerTemplate consumerTemplate = camelContext.createConsumerTemplate(config.getConsumerTemplateCacheSize());
        camelContext.addService((Object)consumerTemplate);
        return consumerTemplate;
    }

    @Bean
    PropertiesParser propertiesParser() {
        return new SpringPropertiesParser();
    }

    @Bean(destroyMethod="")
    PropertiesComponent properties(CamelContext camelContext, PropertiesParser parser) {
        if (camelContext.hasComponent("properties") != null) {
            return (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
        }
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesParser(parser);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext(applicationContext);
        return processor;
    }

    static void afterPropertiesSet(ApplicationContext applicationContext, CamelContext camelContext) throws Exception {
        HealthCheckRegistry healthCheckRegistry;
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, BacklogTracer.class, bt -> camelContext.setExtension(BacklogTracer.class, bt));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, HandleFault.class, arg_0 -> ((CamelContext)camelContext).addInterceptStrategy(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, InflightRepository.class, arg_0 -> ((CamelContext)camelContext).setInflightRepository(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, AsyncProcessorAwaitManager.class, arg_0 -> ((CamelContext)camelContext).setAsyncProcessorAwaitManager(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, ManagementStrategy.class, arg_0 -> ((CamelContext)camelContext).setManagementStrategy(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, ManagementObjectNameStrategy.class, arg_0 -> ((ManagementStrategy)managementStrategy).setManagementObjectNameStrategy(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, EventFactory.class, arg_0 -> ((ManagementStrategy)managementStrategy).setEventFactory(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, UnitOfWorkFactory.class, arg_0 -> ((CamelContext)camelContext).setUnitOfWorkFactory(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, RuntimeEndpointRegistry.class, arg_0 -> ((CamelContext)camelContext).setRuntimeEndpointRegistry(arg_0));
        CamelAutoConfiguration.registerPropertiesForBeanTypes(applicationContext, TypeConverters.class, arg_0 -> ((TypeConverterRegistry)camelContext.getTypeConverterRegistry()).addTypeConverters(arg_0));
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        CamelAutoConfiguration.registerPropertiesForBeanTypesWithCondition(applicationContext, EventNotifier.class, containsEventNotifier.negate(), arg_0 -> ((ManagementStrategy)managementStrategy).addEventNotifier(arg_0));
        CamelAutoConfiguration.registerPropertiesForBeanTypes(applicationContext, EndpointStrategy.class, arg_0 -> ((CamelContext)camelContext).addRegisterEndpointCallback(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, ShutdownStrategy.class, arg_0 -> ((CamelContext)camelContext).setShutdownStrategy(arg_0));
        Predicate<InterceptStrategy> containsInterceptStrategy = camelContext.getInterceptStrategies()::contains;
        CamelAutoConfiguration.registerPropertiesForBeanTypesWithCondition(applicationContext, InterceptStrategy.class, containsInterceptStrategy.negate(), arg_0 -> ((CamelContext)camelContext).addInterceptStrategy(arg_0));
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        CamelAutoConfiguration.registerPropertiesForBeanTypesWithCondition(applicationContext, LifecycleStrategy.class, containsLifecycleStrategy.negate(), arg_0 -> ((CamelContext)camelContext).addLifecycleStrategy(arg_0));
        CamelAutoConfiguration.registerPropertiesForBeanTypes(applicationContext, CamelClusterService.class, CamelAutoConfiguration.addServiceToContext(camelContext));
        Map serviceRegistries = applicationContext.getBeansOfType(ServiceRegistry.class);
        if (serviceRegistries != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = (ServiceRegistry)entry.getValue();
                if (service.getId() == null) {
                    service.setId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Using ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService((Object)service);
            }
        }
        CamelAutoConfiguration.registerPropertiesForBeanTypes(applicationContext, RoutePolicyFactory.class, arg_0 -> ((CamelContext)camelContext).addRoutePolicyFactory(arg_0));
        GlobalSSLContextParametersSupplier sslContextParametersSupplier = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, GlobalSSLContextParametersSupplier.class);
        if (sslContextParametersSupplier != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)sslContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.info("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.setExtension(HealthCheckRegistry.class, (Object)healthCheckRegistry);
        } else {
            healthCheckRegistry = HealthCheckRegistry.get((CamelContext)camelContext);
            healthCheckRegistry.setCamelContext(camelContext);
        }
        CamelAutoConfiguration.registerPropertiesForBeanTypes(applicationContext, HealthCheckRepository.class, arg_0 -> ((HealthCheckRegistry)healthCheckRegistry).addRepository(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, HealthCheckService.class, CamelAutoConfiguration.addServiceToContext(camelContext));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, RouteController.class, arg_0 -> ((CamelContext)camelContext).setRouteController(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, UuidGenerator.class, arg_0 -> ((CamelContext)camelContext).setUuidGenerator(arg_0));
        Predicate<LogListener> containsLogListener = camelContext.getLogListeners()::contains;
        CamelAutoConfiguration.registerPropertiesForBeanTypesWithCondition(applicationContext, LogListener.class, containsLogListener.negate(), arg_0 -> ((CamelContext)camelContext).addLogListener(arg_0));
        CamelAutoConfiguration.registerPropertyForBeanType(applicationContext, ExecutorServiceManager.class, arg_0 -> ((CamelContext)camelContext).setExecutorServiceManager(arg_0));
        CamelAutoConfiguration.initThreadPoolProfiles(applicationContext, camelContext);
    }

    private static <T> Consumer<T> addServiceToContext(CamelContext camelContext) {
        return service -> {
            try {
                camelContext.addService(service);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to add service to Camel context", e);
            }
        };
    }

    private static <T> void registerPropertyForBeanType(ApplicationContext applicationContext, Class<T> beanType, Consumer<T> propertySetter) {
        T propertyBean = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, beanType);
        if (propertyBean == null) {
            return;
        }
        LOG.info("Using custom {}: {}", (Object)beanType.getSimpleName(), propertyBean);
        propertySetter.accept(propertyBean);
    }

    private static <T> void registerPropertiesForBeanTypes(ApplicationContext applicationContext, Class<T> beanType, Consumer<T> propertySetter) {
        CamelAutoConfiguration.registerPropertiesForBeanTypesWithCondition(applicationContext, beanType, b -> true, propertySetter);
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(ApplicationContext applicationContext, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map beans = applicationContext.getBeansOfType(beanType);
        if (!ObjectHelper.isNotEmpty((Object)beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static void initThreadPoolProfiles(ApplicationContext applicationContext, CamelContext camelContext) {
        HashSet defaultIds = new HashSet();
        Map profiles = applicationContext.getBeansOfType(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private static <T> T getSingleBeanOfType(ApplicationContext applicationContext, Class<T> type) {
        Map beans = applicationContext.getBeansOfType(type);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        return null;
    }
}

