/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.Converter"})
public class TypeConverterProcessor
extends AbstractCamelAnnotationProcessor {
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        TypeElement converterAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.Converter");
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(converterAnnotationType);
        TreeMap<String, Element> converterClasses = new TreeMap<String, Element>();
        for (Element element : elements) {
            TypeElement classElement;
            if (!(element instanceof TypeElement) || (classElement = (TypeElement)element).getNestingKind() != NestingKind.TOP_LEVEL) continue;
            String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
            converterClasses.put(javaTypeName, element);
        }
        if (!converterClasses.isEmpty() && !converterClasses.containsKey("org.apache.camel.converter.IOConverter")) {
            Filer filer = this.processingEnv.getFiler();
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org/apache/camel/TypeConverter", converterClasses.values().toArray(new Element[0]));
            try (Writer w = fileObject.openWriter();){
                w.append("# Generated by camel annotation processor\n");
                for (String s : converterClasses.keySet()) {
                    w.append(s).append("\n");
                }
            }
        }
    }
}

