/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.tools.apt.AbstractTypeConverterGenerator;

@SupportedAnnotationTypes(value={"org.apache.camel.Converter"})
public class TypeConverterLoaderGenerator
extends AbstractTypeConverterGenerator {
    @Override
    boolean acceptClass(Element element) {
        return TypeConverterLoaderGenerator.isLoaderEnabled(element);
    }

    @Override
    String convertersKey(String currentClass) {
        return currentClass;
    }

    @Override
    void writeConverters(Map<String, AbstractTypeConverterGenerator.ClassConverters> converters) throws Exception {
        for (Map.Entry<String, AbstractTypeConverterGenerator.ClassConverters> entry : converters.entrySet()) {
            String key = entry.getKey();
            AbstractTypeConverterGenerator.ClassConverters value = entry.getValue();
            this.writeConverters(key, "Loader", false, value);
        }
        this.writeConverterLoaderMetaInfo(converters);
    }

    private void writeConverterLoaderMetaInfo(Map<String, AbstractTypeConverterGenerator.ClassConverters> converters) throws Exception {
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry<String, AbstractTypeConverterGenerator.ClassConverters> entry : converters.entrySet()) {
            String key = entry.getKey();
            AbstractTypeConverterGenerator.ClassConverters value = entry.getValue();
            if (value.isEmpty()) continue;
            sj.add(key);
        }
        if (sj.length() > 0) {
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org/apache/camel/TypeConverterLoader", new Element[0]);
            try (Writer writer = fo.openWriter();){
                writer.append("# Generated by camel annotation processor\n");
                for (String fqn : sj.toString().split(",")) {
                    writer.append("class=").append(fqn).append("Loader\n");
                }
            }
        }
    }

    private static boolean isLoaderEnabled(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"loader".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }
}

