/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.CoreEipAnnotationProcessorHelper;
import org.apache.camel.tools.apt.SpringAnnotationProcessorHelper;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.*", "org.apache.camel.spi.Label"})
public class ModelAnnotationProcessor
extends AbstractCamelAnnotationProcessor {
    private CoreEipAnnotationProcessorHelper coreProcessor = new CoreEipAnnotationProcessorHelper();
    private SpringAnnotationProcessorHelper springProcessor = new SpringAnnotationProcessorHelper();

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(XmlRootElement.class);
        for (Element element : elements) {
            boolean spring;
            if (!(element instanceof TypeElement)) continue;
            TypeElement classElement = (TypeElement)element;
            String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
            boolean core = javaTypeName.startsWith("org.apache.camel.model");
            boolean bl = spring = javaTypeName.startsWith("org.apache.camel.spring") || javaTypeName.startsWith("org.apache.camel.core.xml");
            if (core) {
                this.coreProcessor.processModelClass(this.processingEnv, roundEnv, classElement);
                continue;
            }
            if (!spring) continue;
            this.springProcessor.processModelClass(this.processingEnv, roundEnv, classElement);
        }
    }
}

