/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.apache.camel.tools.apt.AbstractTypeConverterGenerator;

@SupportedAnnotationTypes(value={"org.apache.camel.Converter"})
public class CoreTypeConverterProcessor
extends AbstractTypeConverterGenerator {
    private static final String CORE_STATIC_CLASSNAME = "org.apache.camel.impl.converter.CoreStaticTypeConverterLoader";

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        if (this.processingEnv.getElementUtils().getTypeElement(CORE_STATIC_CLASSNAME) != null) {
            return;
        }
        if (this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.converter.ObjectConverter") == null) {
            return;
        }
        super.doProcess(annotations, roundEnv);
    }

    @Override
    String convertersKey(String currentClass) {
        return CORE_STATIC_CLASSNAME;
    }

    @Override
    boolean acceptClass(Element element) {
        return true;
    }

    @Override
    void writeConverters(Map<String, AbstractTypeConverterGenerator.ClassConverters> converters) throws Exception {
        for (Map.Entry<String, AbstractTypeConverterGenerator.ClassConverters> entry : converters.entrySet()) {
            String key = entry.getKey();
            AbstractTypeConverterGenerator.ClassConverters value = entry.getValue();
            this.writeConverters(key, null, true, value);
        }
    }
}

