/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;

public abstract class AbstractTypeConverterGenerator
extends AbstractCamelAnnotationProcessor {
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        TreeMap<String, ClassConverters> converters = new TreeMap<String, ClassConverters>();
        Comparator comparator = (o1, o2) -> this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o1, (TypeMirror)o2) ? -1 : (this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o2, (TypeMirror)o1) ? 1 : o1.toString().compareTo(o2.toString()));
        TypeElement converterAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.Converter");
        String currentClass = null;
        boolean ignoreOnLoadError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(converterAnnotationType)) {
            if (element.getKind() == ElementKind.CLASS) {
                TypeElement te = (TypeElement)element;
                if (te.getNestingKind().isNested() || !this.acceptClass(te)) continue;
                currentClass = te.getQualifiedName().toString();
                ignoreOnLoadError = AbstractTypeConverterGenerator.isIgnoreOnLoadError(element);
                continue;
            }
            if (currentClass == null || element.getKind() != ElementKind.METHOD) continue;
            String key = this.convertersKey(currentClass);
            ExecutableElement ee = (ExecutableElement)element;
            if (AbstractTypeConverterGenerator.isFallbackConverter(ee)) {
                converters.computeIfAbsent(key, c -> new ClassConverters(comparator)).addFallbackTypeConverter(ee);
                if (!converters.containsKey(key)) continue;
                ((ClassConverters)converters.get(key)).setIgnoreOnLoadError(ignoreOnLoadError);
                continue;
            }
            TypeMirror to = ee.getReturnType();
            TypeMirror from = ee.getParameters().get(0).asType();
            String fromStr = this.toString(from);
            if (!fromStr.endsWith("[]")) {
                TypeElement e = this.processingEnv.getElementUtils().getTypeElement(fromStr);
                if (e != null) {
                    from = e.asType();
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Could not retrieve type element for " + fromStr);
                }
            }
            converters.computeIfAbsent(key, c -> new ClassConverters(comparator)).addTypeConverter(to, from, ee);
            if (!converters.containsKey(key)) continue;
            ((ClassConverters)converters.get(key)).setIgnoreOnLoadError(ignoreOnLoadError);
        }
        this.writeConverters(converters);
    }

    abstract String convertersKey(String var1);

    abstract void writeConverters(Map<String, ClassConverters> var1) throws Exception;

    abstract boolean acceptClass(Element var1);

    private static boolean isIgnoreOnLoadError(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"ignoreOnLoadError".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isFallbackCanPromote(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"fallbackCanPromote".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isAllowNull(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"allowNull".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isFallbackConverter(ExecutableElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"fallback".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    void writeConverters(String fqn, String suffix, boolean staticInstance, ClassConverters converters) throws Exception {
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1) + (suffix != null ? suffix : "");
        JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(p + "." + c, new Element[0]);
        LinkedHashSet<String> converterClasses = new LinkedHashSet<String>();
        try (Writer writer = jfo.openWriter();){
            writer.append("package ").append(p).append(";\n");
            writer.append("\n");
            writer.append("import org.apache.camel.Exchange;\n");
            writer.append("import org.apache.camel.TypeConversionException;\n");
            writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
            writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
            writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
            writer.append("import org.apache.camel.support.TypeConverterSupport;\n");
            writer.append("import org.apache.camel.util.DoubleMap;\n");
            writer.append("\n");
            writer.append("@SuppressWarnings(\"unchecked\")\n");
            writer.append("public class ").append(c).append(" implements TypeConverterLoader {\n");
            writer.append("\n");
            if (staticInstance) {
                writer.append("    public static final ").append(c).append(" INSTANCE = new ").append(c).append("();\n");
            }
            writer.append("\n");
            if (converters.size() > 0L) {
                writer.append("    static abstract class BaseTypeConverter extends TypeConverterSupport {\n");
                writer.append("        private final boolean allowNull;\n");
                writer.append("\n");
                writer.append("        public BaseTypeConverter(boolean allowNull) {\n");
                writer.append("            this.allowNull = allowNull;\n");
                writer.append("        }\n");
                writer.append("\n");
                writer.append("        @Override\n");
                writer.append("        public boolean allowNull() {\n");
                writer.append("            return allowNull;\n");
                writer.append("        }\n");
                writer.append("\n");
                writer.append("        @Override\n");
                writer.append("        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {\n");
                writer.append("            try {\n");
                writer.append("                return (T) doConvert(exchange, value);\n");
                writer.append("            } catch (TypeConversionException e) {\n");
                writer.append("                throw e;\n");
                writer.append("            } catch (Exception e) {\n");
                writer.append("                throw new TypeConversionException(value, type, e);\n");
                writer.append("            }\n");
                writer.append("        }\n");
                writer.append("        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;\n");
                writer.append("    };\n");
                writer.append("\n");
                writer.append("    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(").append(String.valueOf(converters.size())).append(");\n");
                writer.append("\n");
            }
            writer.append("    ").append(staticInstance ? "private " : "public ").append(c).append("() {\n");
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    private void registerConverters() {\n");
            for (Map.Entry<String, Map<TypeMirror, ExecutableElement>> to : converters.getConverters().entrySet()) {
                for (Map.Entry<TypeMirror, ExecutableElement> from : to.getValue().entrySet()) {
                    boolean allowNull = AbstractTypeConverterGenerator.isAllowNull(from.getValue());
                    writer.append("        converters.put(").append(to.getKey()).append(".class").append(", ").append(this.toString(from.getKey())).append(".class, new BaseTypeConverter(").append(Boolean.toString(allowNull)).append(") {\n");
                    writer.append("            @Override\n");
                    writer.append("            public Object doConvert(Exchange exchange, Object value) throws Exception {\n");
                    writer.append("                return ").append(this.toJava(from.getValue(), converterClasses)).append(";\n");
                    writer.append("            }\n");
                    writer.append("        });\n");
                }
            }
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    @Override\n");
            writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
            if (converters.size() > 0L) {
                if (converters.isIgnoreOnLoadError()) {
                    writer.append("        try {\n");
                    writer.append("            registerConverters();\n");
                    writer.append("            converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));\n");
                    writer.append("        } catch (Throwable e) {\n");
                    writer.append("            // ignore on load error\n");
                    writer.append("        }\n");
                } else {
                    writer.append("        registerConverters();\n");
                    writer.append("        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));\n");
                }
            }
            for (ExecutableElement ee : converters.getFallbackConverters()) {
                boolean allowNull = AbstractTypeConverterGenerator.isAllowNull(ee);
                boolean canPromote = AbstractTypeConverterGenerator.isFallbackCanPromote(ee);
                writer.append("        registry.addFallbackTypeConverter(new TypeConverterSupport() {\n");
                if (allowNull) {
                    writer.append("            @Override\n");
                    writer.append("            public boolean allowNull() {\n");
                    writer.append("                return ").append(Boolean.toString(allowNull)).append(";\n");
                    writer.append("            }\n");
                }
                writer.append("            @Override\n");
                writer.append("            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {\n");
                writer.append("                try {\n");
                writer.append("                    return (T) ").append(this.toJavaFallback(ee, converterClasses)).append(";\n");
                writer.append("                } catch (TypeConversionException e) {\n");
                writer.append("                    throw e;\n");
                writer.append("                } catch (Exception e) {\n");
                writer.append("                    throw new TypeConversionException(value, type, e);\n");
                writer.append("                }\n");
                writer.append("            }\n");
                writer.append("        }, ").append(Boolean.toString(canPromote)).append(");\n");
            }
            writer.append("    }\n");
            writer.append("\n");
            for (String f : converterClasses) {
                String s = f.substring(f.lastIndexOf(46) + 1);
                String v = s.substring(0, 1).toLowerCase() + s.substring(1);
                writer.append("    private volatile ").append(f).append(" ").append(v).append(";\n");
                writer.append("    private ").append(f).append(" get").append(s).append("() {\n");
                writer.append("        if (").append(v).append(" == null) {\n");
                writer.append("            synchronized (this) {\n");
                writer.append("                if (").append(v).append(" == null) {\n");
                writer.append("                    ").append(v).append(" = new ").append(f).append("();\n");
                writer.append("                }\n");
                writer.append("            }\n");
                writer.append("        }\n");
                writer.append("        return ").append(v).append(";\n");
                writer.append("    }\n");
            }
            writer.append("}\n");
            writer.flush();
        }
    }

    private String toString(TypeMirror type) {
        return type.toString().replaceAll("<.*>", "");
    }

    private String toJava(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(0).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + cast + "value" + (converter.getParameters().size() == 2 ? ", exchange" : "") + ")";
    }

    private String toJavaFallback(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(converter.getParameters().size() - 2).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.getParameters().size() == 4 ? "exchange, " : "") + cast + "value, registry)";
    }

    public static final class ClassConverters {
        private final Comparator<TypeMirror> comparator;
        private final Map<String, Map<TypeMirror, ExecutableElement>> converters = new TreeMap<String, Map<TypeMirror, ExecutableElement>>();
        private final List<ExecutableElement> fallbackConverters = new ArrayList<ExecutableElement>();
        private int size;
        private int sizeFallback;
        private boolean ignoreOnLoadError;

        ClassConverters(Comparator<TypeMirror> comparator) {
            this.comparator = comparator;
        }

        public boolean isIgnoreOnLoadError() {
            return this.ignoreOnLoadError;
        }

        void setIgnoreOnLoadError(boolean ignoreOnLoadError) {
            this.ignoreOnLoadError = ignoreOnLoadError;
        }

        void addTypeConverter(TypeMirror to, TypeMirror from, ExecutableElement ee) {
            this.converters.computeIfAbsent(ClassConverters.toString(to), c -> new TreeMap(this.comparator)).put(from, ee);
            ++this.size;
        }

        void addFallbackTypeConverter(ExecutableElement ee) {
            this.fallbackConverters.add(ee);
            ++this.sizeFallback;
        }

        public Map<String, Map<TypeMirror, ExecutableElement>> getConverters() {
            return this.converters;
        }

        public List<ExecutableElement> getFallbackConverters() {
            return this.fallbackConverters;
        }

        public long size() {
            return this.size;
        }

        public long sizeFallback() {
            return this.sizeFallback;
        }

        public boolean isEmpty() {
            return this.size == 0 && this.sizeFallback == 0;
        }

        private static String toString(TypeMirror type) {
            return type.toString().replaceAll("<.*>", "");
        }
    }
}

