/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.netflix;

import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFunction;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.core.convert.ConversionService;

public class CamelCloudNetflixServiceLoadBalancer
implements ServiceLoadBalancer {
    private final LoadBalancerClient client;
    private final List<ConversionService> conversionServices;

    public CamelCloudNetflixServiceLoadBalancer(LoadBalancerClient client, List<ConversionService> conversionServices) {
        this.client = client;
        this.conversionServices = conversionServices;
    }

    public <T> T process(String serviceName, ServiceLoadBalancerFunction<T> function) throws Exception {
        return (T)this.client.execute(serviceName, instance -> {
            DefaultServiceDefinition definition = null;
            if (instance instanceof RibbonLoadBalancerClient.RibbonServer) {
                ConversionService cs;
                Server server = ((RibbonLoadBalancerClient.RibbonServer)RibbonLoadBalancerClient.RibbonServer.class.cast(instance)).getServer();
                for (int i = 0; !(i >= this.conversionServices.size() || (cs = this.conversionServices.get(i)).canConvert(server.getClass(), ServiceDefinition.class) && (definition = (ServiceDefinition)cs.convert((Object)server, ServiceDefinition.class)) != null); ++i) {
                }
            }
            if (definition == null) {
                definition = new DefaultServiceDefinition(instance.getServiceId(), instance.getHost(), instance.getPort(), instance.getMetadata());
            }
            return function.apply(definition);
        });
    }
}

