/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public class JooqConsumer
extends ScheduledBatchPollingConsumer {
    private final Processor processor;
    private final JooqEndpoint endpoint;

    public JooqConsumer(JooqEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected int poll() throws Exception {
        JooqConfiguration configuration = this.endpoint.getConfiguration();
        Configuration dbConfig = configuration.getDatabaseConfiguration();
        Class<?> entityType = configuration.getEntityType();
        DSLContext context = DSL.using((Configuration)dbConfig);
        LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
        Result results = context.selectFrom(this.getTable(entityType)).fetch();
        for (UpdatableRecord result : results) {
            DataHolder holder = new DataHolder();
            holder.result = result;
            holder.exchange = this.createExchange(result);
            answer.add(holder);
        }
        int messagePolled = this.processBatch(CastUtils.cast(answer));
        if (configuration.isConsumeDelete()) {
            context.batchDelete((Collection)results).execute();
        }
        return messagePolled;
    }

    protected Exchange createExchange(Object result) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(result);
        return exchange;
    }

    private Table getTable(Class<?> entityType) {
        UpdatableRecord object = (UpdatableRecord)org.apache.camel.support.ObjectHelper.newInstance(entityType);
        Table table = object.getTable();
        return table;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.isBatchAllowed()) {
            for (int i = 0; i < total; ++i) {
                DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
                this.getProcessor().process(holder.exchange);
            }
        }
        return total;
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object result;

        private DataHolder() {
        }
    }
}

