/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs2;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hdfs2.HdfsComponent;
import org.apache.camel.component.hdfs2.HdfsConfiguration;
import org.apache.camel.component.hdfs2.HdfsConsumer;
import org.apache.camel.component.hdfs2.HdfsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.14.0", scheme="hdfs2,hdfs", title="HDFS2", syntax="hdfs2:hostName:port/path", label="hadoop,file")
public class HdfsEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private final HdfsConfiguration config = new HdfsConfiguration();

    public HdfsEndpoint(String endpointUri, HdfsComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.config.parseURI(new URI(endpointUri));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.config.checkConsumerOptions();
        HdfsConsumer answer = new HdfsConsumer(this, processor, this.config);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() {
        this.config.checkProducerOptions();
        return new HdfsProducer(this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public HdfsConfiguration getConfig() {
        return this.config;
    }
}

