/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.ObjectInput;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty4.NettyConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;
import org.w3c.dom.Document;

public class NettyConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(11);

    private void registerConverters() {
        this.converters.put(byte[].class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toByteArray((ByteBuf)value, exchange);
            }
        });
        this.converters.put(ByteBuf.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toByteBuffer((byte[])value);
            }
        });
        this.converters.put(ByteBuf.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toByteBuffer((String)value, exchange);
            }
        });
        this.converters.put(InputStream.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toInputStream((ByteBuf)value, exchange);
            }
        });
        this.converters.put(ObjectInput.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toObjectInput((ByteBuf)value, exchange);
            }
        });
        this.converters.put(String.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toString((ByteBuf)value, exchange);
            }
        });
        this.converters.put(DOMSource.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toDOMSource((ByteBuf)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toSAXSource((ByteBuf)value, exchange);
            }
        });
        this.converters.put(StAXSource.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toStAXSource((ByteBuf)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toStreamSource((ByteBuf)value, exchange);
            }
        });
        this.converters.put(Document.class, ByteBuf.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyConverter.toDocument((ByteBuf)value, exchange);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

