/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.cloud.DiscoverableService;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowProducer;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CollectionHelper;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

@UriEndpoint(firstVersion="2.16.0", scheme="undertow", title="Undertow", syntax="undertow:httpURI", label="http,websocket", lenientProperties=true)
public class UndertowEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware,
DiscoverableService {
    private UndertowComponent component;
    private SSLContext sslContext;
    private OptionMap optionMap;
    private HttpHandlerRegistrationInfo registrationInfo;
    private CamelWebSocketHandler webSocketHttpHandler;
    private boolean isWebSocket;
    @UriPath
    @Metadata(required=true)
    private URI httpURI;
    @UriParam(label="advanced")
    private UndertowHttpBinding undertowHttpBinding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new UndertowHeaderFilterStrategy();
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="consumer")
    private String httpMethodRestrict;
    @UriParam(label="consumer", defaultValue="false")
    private Boolean matchOnUriPrefix = Boolean.FALSE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean throwExceptionOnFailure = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="false")
    private Boolean transferException = Boolean.FALSE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean keepAlive = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean tcpNoDelay = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean reuseAddresses = Boolean.TRUE;
    @UriParam(label="producer", prefix="option.", multiValue=true)
    private Map<String, Object> options;
    @UriParam(label="consumer")
    private boolean optionsEnabled;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;
    @UriParam(label="producer,websocket")
    private Boolean sendToAll;
    @UriParam(label="producer,websocket", defaultValue="30000")
    private Integer sendTimeout = 30000;
    @UriParam(label="consumer,websocket", defaultValue="false")
    private boolean useStreaming;
    @UriParam(label="consumer,websocket", defaultValue="false")
    private boolean fireWebSocketChannelEvents;

    public UndertowEndpoint(String uri, UndertowComponent component) {
        super(uri, (Component)component);
        this.component = component;
    }

    public UndertowComponent getComponent() {
        return this.component;
    }

    public Producer createProducer() throws Exception {
        return new UndertowProducer(this, this.optionMap);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new UndertowConsumer(this, processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Map<String, String> getServiceProperties() {
        return CollectionHelper.immutableMapOf((Object)"service.port", (Object)Integer.toString(this.httpURI.getPort()), (Object[])new Object[]{"service.path", this.httpURI.getPath(), "service.protocol", this.httpURI.getScheme()});
    }

    public Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange exchange = this.createExchange(ExchangePattern.InOut);
        Message in = this.getUndertowHttpBinding().toCamelMessage(httpExchange, exchange);
        exchange.setProperty("CamelCharsetName", (Object)httpExchange.getRequestCharset());
        in.setHeader("CamelHttpCharacterEncoding", (Object)httpExchange.getRequestCharset());
        exchange.setIn(in);
        return exchange;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public URI getHttpURI() {
        return this.httpURI;
    }

    public void setHttpURI(URI httpURI) {
        this.httpURI = UndertowHelper.makeHttpURI(httpURI);
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public Boolean getMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(Boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(Boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public Boolean getTransferException() {
        return this.transferException;
    }

    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        if (this.undertowHttpBinding == null) {
            this.undertowHttpBinding = new DefaultUndertowHttpBinding();
            this.undertowHttpBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.undertowHttpBinding.setTransferException(this.getTransferException());
        }
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Boolean getReuseAddresses() {
        return this.reuseAddresses;
    }

    public void setReuseAddresses(Boolean reuseAddresses) {
        this.reuseAddresses = reuseAddresses;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public Boolean getSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(Boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public Integer getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(Integer sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    public boolean isFireWebSocketChannelEvents() {
        return this.fireWebSocketChannelEvents;
    }

    public void setFireWebSocketChannelEvents(boolean fireWebSocketChannelEvents) {
        this.fireWebSocketChannelEvents = fireWebSocketChannelEvents;
    }

    protected void doStart() throws Exception {
        OptionMap.Builder builder;
        super.doStart();
        String scheme = this.httpURI.getScheme();
        boolean bl = this.isWebSocket = "ws".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
        if (this.sslContextParameters != null) {
            this.sslContext = this.sslContextParameters.createSSLContext(this.getCamelContext());
        }
        if (this.options != null && !this.options.isEmpty()) {
            ClassLoader cl = this.getComponent().getCamelContext().getApplicationContextClassLoader();
            if (cl == null) {
                cl = Options.class.getClassLoader();
            }
            OptionMap.Builder builder2 = OptionMap.builder();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                key = key.toUpperCase(Locale.ENGLISH).replace('-', '_');
                key = Options.class.getName() + "." + key;
                Option option = Option.fromString((String)key, (ClassLoader)cl);
                value = option.parseValue(value.toString(), cl);
                this.log.trace("Parsed option {}={}", (Object)option.getName(), value);
                builder2.set(option, value);
            }
            this.optionMap = builder2.getMap();
        } else {
            this.optionMap = OptionMap.EMPTY;
        }
        if (this.keepAlive != null && !this.optionMap.contains(Options.KEEP_ALIVE)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.KEEP_ALIVE, (Object)this.keepAlive);
            this.optionMap = builder.getMap();
        }
        if (this.tcpNoDelay != null && !this.optionMap.contains(Options.TCP_NODELAY)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.TCP_NODELAY, (Object)this.tcpNoDelay);
            this.optionMap = builder.getMap();
        }
        if (this.reuseAddresses != null && !this.optionMap.contains(Options.REUSE_ADDRESSES)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.REUSE_ADDRESSES, (Object)this.reuseAddresses);
            this.optionMap = builder.getMap();
        }
    }

    public boolean isWebSocket() {
        return this.isWebSocket;
    }

    public HttpHandlerRegistrationInfo getHttpHandlerRegistrationInfo() {
        if (this.registrationInfo == null) {
            this.registrationInfo = new HttpHandlerRegistrationInfo(this.getHttpURI(), this.getHttpMethodRestrict(), this.getMatchOnUriPrefix());
        }
        return this.registrationInfo;
    }

    public CamelWebSocketHandler getWebSocketHttpHandler() {
        if (this.webSocketHttpHandler == null) {
            this.webSocketHttpHandler = new CamelWebSocketHandler();
        }
        return this.webSocketHttpHandler;
    }
}

