/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.mina2.Mina2Configuration;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.core.filterchain.IoFilter;

@org.apache.camel.spi.annotations.Component(value="mina,mina2")
public class Mina2Component
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private Mina2Configuration configuration;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public Mina2Component() {
    }

    public Mina2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Mina2Configuration config = this.configuration != null ? this.configuration.copy() : new Mina2Configuration();
        URI u = new URI(remaining);
        config.setHost(u.getHost());
        config.setPort(u.getPort());
        config.setProtocol(u.getScheme());
        config.setFilters(this.resolveAndRemoveReferenceListParameter(parameters, "filters", IoFilter.class));
        this.setProperties(config, parameters);
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return this.createEndpoint(uri, config);
    }

    public Endpoint createEndpoint(Mina2Configuration config) throws Exception {
        return this.createEndpoint(config.getUriString(), config);
    }

    private Endpoint createEndpoint(String uri, Mina2Configuration config) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String protocol = config.getProtocol();
        Mina2Endpoint endpoint = null;
        if (protocol != null && (protocol.equals("tcp") || config.isDatagramProtocol() || protocol.equals("vm"))) {
            endpoint = new Mina2Endpoint(uri, (Component)this, config);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
        }
        if (config.isSync()) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    public Mina2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Mina2Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

