/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelperKeyPairProvider
extends AbstractKeyPairProvider {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CamelContext camelContext;
    private String[] resources;
    private Supplier<char[]> passwordFinder;

    public ResourceHelperKeyPairProvider() {
    }

    public ResourceHelperKeyPairProvider(String[] resources, CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resources = resources;
    }

    public ResourceHelperKeyPairProvider(String[] resources, Supplier<char[]> passwordFinder, CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public Supplier<char[]> getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(Supplier<char[]> passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.resources.length);
        for (String resource : this.resources) {
            InputStream is;
            InputStreamReader isr;
            PEMParser r;
            block8: {
                r = null;
                isr = null;
                is = null;
                try {
                    is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)resource);
                    isr = new InputStreamReader(is);
                    r = new PEMParser((Reader)isr);
                    Object o = r.readObject();
                    JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                    pemConverter.setProvider("BC");
                    if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                        JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                        PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.get());
                        o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                    }
                    if (o instanceof PEMKeyPair) {
                        o = pemConverter.getKeyPair((PEMKeyPair)o);
                        keys.add((KeyPair)o);
                        break block8;
                    }
                    if (!(o instanceof KeyPair)) break block8;
                    keys.add((KeyPair)o);
                }
                catch (Exception e) {
                    try {
                        this.log.warn("Unable to read key", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                        throw throwable;
                    }
                    IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                    continue;
                }
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
        }
        return keys;
    }
}

