/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.processor.idempotent;

import java.io.IOException;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;

public class HBaseIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private final String tableName;
    private final String family;
    private final String qualifier;
    private final Configuration configuration;
    private Connection connection;
    private Table table;

    public HBaseIdempotentRepository(Configuration configuration, String tableName, String family, String qualifier) throws IOException {
        this.tableName = tableName;
        this.family = family;
        this.qualifier = qualifier;
        this.configuration = configuration;
        this.connection = null;
        this.table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String o) {
        try {
            String string = this.tableName.intern();
            synchronized (string) {
                if (this.contains(o)) {
                    return false;
                }
                byte[] b = HBaseHelper.toBytes(o);
                Put put = new Put(b);
                put.addColumn(HBaseHelper.getHBaseFieldAsBytes(this.family), HBaseHelper.getHBaseFieldAsBytes(this.qualifier), b);
                this.table.put(put);
                return true;
            }
        }
        catch (Exception e) {
            this.log.warn("Error adding object {} to HBase repository.", (Object)o);
            return false;
        }
    }

    public boolean contains(String o) {
        try {
            byte[] b = HBaseHelper.toBytes(o);
            Get get = new Get(b);
            get.addColumn(HBaseHelper.getHBaseFieldAsBytes(this.family), HBaseHelper.getHBaseFieldAsBytes(this.qualifier));
            return this.table.exists(get);
        }
        catch (Exception e) {
            this.log.warn("Error reading object {} from HBase repository.", (Object)o);
            return false;
        }
    }

    public boolean remove(String o) {
        try {
            byte[] b = HBaseHelper.toBytes(o);
            if (this.table.exists(new Get(b))) {
                Delete delete = new Delete(b);
                this.table.delete(delete);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.warn("Error removing object {} from HBase repository.", (Object)o);
            return false;
        }
    }

    public boolean confirm(String o) {
        return true;
    }

    public void clear() {
        Scan s = new Scan();
        try {
            ResultScanner scanner = this.table.getScanner(s);
            for (Result rr : scanner) {
                Delete d = new Delete(rr.getRow());
                this.table.delete(d);
            }
        }
        catch (Exception e) {
            this.log.warn("Error clear HBase repository {}", (Object)this.table);
        }
    }

    protected void doStart() throws Exception {
        this.connection = ConnectionFactory.createConnection((Configuration)this.configuration);
        this.table = this.connection.getTable(TableName.valueOf((String)this.tableName));
    }

    protected void doStop() throws Exception {
        if (this.table != null) {
            this.table.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

