/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hbase.converter.HBaseModelConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class HBaseModelConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(12);

    private void registerConverters() {
        this.converters.put(byte[].class, Boolean.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.booleanToBytes((Boolean)value);
            }
        });
        this.converters.put(byte[].class, Double.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.doubleToBytes((Double)value);
            }
        });
        this.converters.put(byte[].class, Float.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.floatToBytes((Float)value);
            }
        });
        this.converters.put(byte[].class, Integer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.integerToBytes((Integer)value);
            }
        });
        this.converters.put(byte[].class, Long.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.longToBytes((Long)value);
            }
        });
        this.converters.put(byte[].class, Short.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.shortToBytes((Short)value);
            }
        });
        this.converters.put(Boolean.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToBoolean((byte[])value);
            }
        });
        this.converters.put(Double.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToDouble((byte[])value);
            }
        });
        this.converters.put(Float.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToFloat((byte[])value);
            }
        });
        this.converters.put(Integer.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToInteger((byte[])value);
            }
        });
        this.converters.put(Long.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToLong((byte[])value);
            }
        });
        this.converters.put(Short.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HBaseModelConverter.bytesToShort((byte[])value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

