/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.impl.cloud.AbstractServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.core.convert.ConversionService;

public class CamelSpringCloudServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelSpringCloudServiceRegistry.class);
    private final List<ServiceDefinition> definitions = new ArrayList<ServiceDefinition>();
    private final List<ConversionService> conversionServices;
    private final ServiceRegistry serviceRegistry;
    private final Class<? extends Registration> registrationType;

    public CamelSpringCloudServiceRegistry(Collection<ConversionService> conversionServices, ServiceRegistry serviceRegistry) {
        this.conversionServices = new ArrayList<ConversionService>(conversionServices);
        this.serviceRegistry = serviceRegistry;
        this.registrationType = this.determineRegistrationType("register");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServiceDefinition definition) {
        CamelSpringCloudServiceRegistry camelSpringCloudServiceRegistry = this;
        synchronized (camelSpringCloudServiceRegistry) {
            if (this.definitions.stream().noneMatch(d -> this.matchById((ServiceDefinition)d, definition))) {
                LOGGER.debug("Register service with definition: {} with registrations: {}", (Object)definition, this.registrationType);
                Registration result = this.convertServiceDefinition(definition);
                this.serviceRegistry.register(result);
                this.definitions.add(definition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(ServiceDefinition definition) {
        CamelSpringCloudServiceRegistry camelSpringCloudServiceRegistry = this;
        synchronized (camelSpringCloudServiceRegistry) {
            if (this.definitions.stream().noneMatch(d -> this.matchById((ServiceDefinition)d, definition))) {
                LOGGER.debug("Deregister service with definition: {} with registrations: {}", (Object)definition, this.registrationType);
                Registration result = this.convertServiceDefinition(definition);
                this.serviceRegistry.deregister(result);
            }
            this.definitions.removeIf(d -> this.matchById((ServiceDefinition)d, definition));
        }
    }

    protected void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        CamelSpringCloudServiceRegistry camelSpringCloudServiceRegistry = this;
        synchronized (camelSpringCloudServiceRegistry) {
            new ArrayList<ServiceDefinition>(this.definitions).forEach(this::deregister);
        }
    }

    public ServiceRegistry getNativeServiceRegistry() {
        return this.serviceRegistry;
    }

    public <R extends Registration, T extends ServiceRegistry<R>> T getNativeServiceRegistry(Class<T> type) {
        return (T)((ServiceRegistry)type.cast(this.serviceRegistry));
    }

    private Class<? extends Registration> determineRegistrationType(String methodName) {
        Method[] methods;
        Class type = null;
        for (Method method : methods = this.serviceRegistry.getClass().getDeclaredMethods()) {
            Class<?> parameterType;
            if (!methodName.equals(method.getName()) || method.getParameterCount() != 1 || !Registration.class.isAssignableFrom(parameterType = method.getParameterTypes()[0])) continue;
            if (type == null) {
                type = parameterType;
                continue;
            }
            if (!type.isAssignableFrom(parameterType)) continue;
            type = parameterType;
        }
        return type != null ? type : Registration.class;
    }

    private boolean matchById(ServiceDefinition definition, ServiceDefinition reference) {
        if (definition.getId() == null || reference.getId() == null) {
            return false;
        }
        return Objects.equals(definition.getId(), reference.getId());
    }

    private Registration convertServiceDefinition(ServiceDefinition definition) {
        for (int i = 0; i < this.conversionServices.size(); ++i) {
            ConversionService cs = this.conversionServices.get(i);
            if (!cs.canConvert(ServiceDefinition.class, this.registrationType)) continue;
            return (Registration)cs.convert((Object)definition, this.registrationType);
        }
        throw new IllegalStateException("Unable to convert service definition to native registration of type:" + this.registrationType);
    }
}

