/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.component.caffeine.cache.CaffeineCacheComponent;
import org.apache.camel.component.caffeine.cache.CaffeineCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.20.0", scheme="caffeine-cache", title="Caffeine Cache", syntax="caffeine-cache:cacheName", label="cache,datagrid,clustering")
public class CaffeineCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final CaffeineConfiguration configuration;
    private Cache cache;

    CaffeineCacheEndpoint(String uri, CaffeineCacheComponent component, String cacheName, CaffeineConfiguration configuration) throws Exception {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CaffeineCacheProducer(this, this.cacheName, this.configuration, this.cache);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getCache())) {
            this.cache = this.configuration.getCache();
        } else {
            Caffeine builder = Caffeine.newBuilder();
            if (this.configuration.getEvictionType() == EvictionType.SIZE_BASED) {
                builder.initialCapacity(this.configuration.getInitialCapacity());
                builder.maximumSize((long)this.configuration.getMaximumSize());
            } else if (this.configuration.getEvictionType() == EvictionType.TIME_BASED) {
                builder.expireAfterAccess((long)this.configuration.getExpireAfterAccessTime(), TimeUnit.SECONDS);
                builder.expireAfterWrite((long)this.configuration.getExpireAfterWriteTime(), TimeUnit.SECONDS);
            }
            if (this.configuration.isStatsEnabled()) {
                if (ObjectHelper.isEmpty((Object)this.configuration.getStatsCounter())) {
                    builder.recordStats();
                } else {
                    builder.recordStats(() -> this.configuration.getStatsCounter());
                }
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRemovalListener())) {
                builder.removalListener(this.configuration.getRemovalListener());
            }
            this.cache = builder.build();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("The caffeine-cache component doesn't support consumer");
    }
}

