/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.LoadPropertiesException;
import org.apache.camel.TypeConverter;
import org.apache.camel.core.osgi.OsgiBeanRepository;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.osgi.framework.BundleContext;

public class OsgiDefaultCamelContext
extends DefaultCamelContext {
    private final BundleContext bundleContext;

    public OsgiDefaultCamelContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
        OsgiBeanRepository repo1 = new OsgiBeanRepository(bundleContext);
        this.setRegistry((Registry)new DefaultRegistry(new BeanRepository[]{repo1}));
        this.addLifecycleStrategy((LifecycleStrategy)repo1);
        this.setApplicationContextClassLoader(new BundleDelegatingClassLoader(bundleContext.getBundle()));
    }

    public Map<String, Properties> findComponents() throws LoadPropertiesException, IOException {
        return BundleContextUtils.findComponents(this.bundleContext, (CamelContext)this);
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, (CamelContext)this, this.getInjector(), finder);
    }
}

