/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.LifecycleStrategySupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiBeanRepository
extends LifecycleStrategySupport
implements BeanRepository,
Service,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiBeanRepository.class);
    private final BundleContext bundleContext;
    private final Map<ServiceReference<?>, AtomicLong> serviceReferenceUsageMap = new ConcurrentHashMap();

    public OsgiBeanRepository(BundleContext bc) {
        this.bundleContext = bc;
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object service = null;
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(type.getName(), "(name=" + name + ")");
            if (refs != null && refs.length > 0) {
                ServiceReference sr = refs[0];
                this.incrementServiceUsage(sr);
                service = this.bundleContext.getService(sr);
            }
        }
        catch (Exception ex) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)ex);
        }
        service = this.unwrap(service);
        return type.cast(service);
    }

    public Object lookupByName(String name) {
        ServiceReference sr;
        Object service;
        block5: {
            service = null;
            sr = this.bundleContext.getServiceReference(name);
            if (sr == null) {
                String filterExpression = "(service.pid=" + name + ")";
                try {
                    ServiceReference[] refs = this.bundleContext.getServiceReferences((String)null, filterExpression);
                    if (refs != null && refs.length > 0) {
                        sr = refs[0];
                    }
                }
                catch (InvalidSyntaxException ex) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Invalid OSGi service reference filter, skipped lookup by service.pid. Filter expression: {}", (Object)filterExpression, (Object)ex);
                }
            }
        }
        if (sr != null) {
            this.incrementServiceUsage(sr);
            service = this.bundleContext.getService(sr);
        }
        service = this.unwrap(service);
        return service;
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        HashMap<String, T> result = new HashMap<String, T>();
        int count = 0;
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(type.getName(), null);
            if (refs != null) {
                for (ServiceReference sr : refs) {
                    if (sr == null) continue;
                    Object service = this.bundleContext.getService(sr);
                    this.incrementServiceUsage(sr);
                    if (service == null) continue;
                    String name = (String)sr.getProperty("name");
                    service = this.unwrap(service);
                    if (name != null) {
                        result.put(name, type.cast(service));
                        continue;
                    }
                    result.put(type.getSimpleName() + count, type.cast(service));
                    ++count;
                }
            }
        }
        catch (Exception ex) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)ex);
        }
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        return new HashSet<T>(map.values());
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.serviceReferenceUsageMap.forEach(this::drainServiceUsage);
        this.serviceReferenceUsageMap.clear();
    }

    private void drainServiceUsage(ServiceReference<?> serviceReference, AtomicLong serviceUsageCount) {
        if (serviceUsageCount != null && serviceReference != null) {
            while (serviceUsageCount.decrementAndGet() >= 0L) {
                this.bundleContext.ungetService(serviceReference);
            }
        }
    }

    private void incrementServiceUsage(ServiceReference<?> sr) {
        AtomicLong serviceUsageCount = this.serviceReferenceUsageMap.get(sr);
        if (serviceUsageCount != null) {
            serviceUsageCount.incrementAndGet();
        } else {
            this.serviceReferenceUsageMap.merge(sr, new AtomicLong(1L), (existingServiceUsageCount, newServiceUsageCount) -> {
                existingServiceUsageCount.getAndAdd(newServiceUsageCount.get());
                return existingServiceUsageCount;
            });
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 4) {
            ServiceReference serviceReference = event.getServiceReference();
            AtomicLong serviceUsageCount = this.serviceReferenceUsageMap.remove(serviceReference);
            this.drainServiceUsage(serviceReference, serviceUsageCount);
        }
    }
}

