/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.support.AsyncProcessorSupport;

public class CamelLogProcessor
extends AsyncProcessorSupport
implements IdAware {
    private String id;
    private CamelLogger logger;
    private ExchangeFormatter formatter = new ToStringExchangeFormatter();
    private MaskingFormatter maskingFormatter;
    private Set<LogListener> listeners;

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger logger) {
        this.logger = logger;
    }

    public CamelLogProcessor(CamelLogger logger, ExchangeFormatter formatter, MaskingFormatter maskingFormatter, Set<LogListener> listeners) {
        this(logger);
        this.formatter = formatter;
        this.maskingFormatter = maskingFormatter;
        this.listeners = listeners;
    }

    public String toString() {
        return "Logger[" + this.logger + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.logger.shouldLog()) {
            String output = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.logger.log(output);
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange, Throwable exception) {
        if (this.logger.shouldLog()) {
            String output = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.logger.log(output, exception);
        }
    }

    public void process(Exchange exchange, String message) {
        if (this.logger.shouldLog()) {
            String output = this.formatter.format(exchange) + message;
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange, output);
            this.logger.log(output);
        }
    }

    private String fireListeners(Exchange exchange, String message) {
        if (this.listeners == null) {
            return message;
        }
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output = listener.onLog(exchange, this.logger, message);
                message = output != null ? output : message;
            }
            catch (Throwable t) {
                this.log.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("", t);
            }
        }
        return message;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public void setLogName(String logName) {
        this.logger.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.logger.setLevel(level);
    }

    public void setMarker(String marker) {
        this.logger.setMarker(marker);
    }

    public void setMaskingFormatter(MaskingFormatter maskingFormatter) {
        this.maskingFormatter = maskingFormatter;
    }

    static class ToStringExchangeFormatter
    implements ExchangeFormatter {
        ToStringExchangeFormatter() {
        }

        public String format(Exchange exchange) {
            return exchange.toString();
        }
    }
}

