/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.JSonSchemaHelper;
import org.apache.camel.support.service.ServiceHelper;

@ManagedResource(description="Managed Processor")
public class ManagedProcessor
extends ManagedPerformanceCounter
implements ManagedInstance,
ManagedProcessorMBean {
    private final CamelContext context;
    private final Processor processor;
    private final ProcessorDefinition<?> definition;
    private final String id;
    private String stepId;
    private Route route;

    public ManagedProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) {
        this.context = context;
        this.processor = processor;
        this.definition = definition;
        this.id = definition.idOrCreate(context.getNodeIdFactory());
        StepDefinition step = definition instanceof StepDefinition ? (StepDefinition)definition : (StepDefinition)ProcessorDefinitionHelper.findFirstParentOfType(StepDefinition.class, definition, (boolean)true);
        this.stepId = step != null ? step.idOrCreate(context.getNodeIdFactory()) : null;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().isDefaultOrExtended();
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getInstance() {
        return this.processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ProcessorDefinition<?> getDefinition() {
        return this.definition;
    }

    public String getId() {
        return this.id;
    }

    public String getStepId() {
        return this.stepId;
    }

    public Integer getIndex() {
        return this.definition.getIndex();
    }

    public Boolean getSupportExtendedInformation() {
        return false;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public String getState() {
        if (this.processor instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.processor).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    public String getProcessorId() {
        return this.id;
    }

    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.startService((Object)this.getProcessor());
    }

    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.stopService((Object)this.getProcessor());
    }

    public String informationJson() {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).explainEipJson(this.id, true);
    }

    public TabularData explain(boolean allOptions) {
        try {
            String json = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).explainEipJson(this.id, allOptions);
            List rows = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainEipTabularType());
            for (Map row : rows) {
                String name = (String)row.get("name");
                String kind = (String)row.get("kind");
                String label = row.get("label") != null ? (String)row.get("label") : "";
                String type = (String)row.get("type");
                String javaType = (String)row.get("javaType");
                String deprecated = row.get("deprecated") != null ? (String)row.get("deprecated") : "";
                String value = row.get("value") != null ? (String)row.get("value") : "";
                String defaultValue = row.get("defaultValue") != null ? (String)row.get("defaultValue") : "";
                String description = row.get("description") != null ? (String)row.get("description") : "";
                CompositeType ct = CamelOpenMBeanTypes.explainEipsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "label", "type", "java type", "deprecated", "value", "default value", "description"}, new Object[]{name, kind, label, type, javaType, deprecated, value, defaultValue, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String dumpProcessorAsXml() throws Exception {
        return ModelHelper.dumpModelAsXml((CamelContext)this.context, this.definition);
    }
}

