/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEndpointMBean;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.JSonSchemaHelper;

@ManagedResource(description="Managed Endpoint")
public class ManagedEndpoint
implements ManagedInstance,
ManagedEndpointMBean {
    private final Endpoint endpoint;

    public ManagedEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getCamelId() {
        return this.endpoint.getCamelContext().getName();
    }

    public String getCamelManagementName() {
        return this.endpoint.getCamelContext().getManagementName();
    }

    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    public String getState() {
        if (this.endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String informationJson() {
        return ((CatalogCamelContext)this.endpoint.getCamelContext().adapt(CatalogCamelContext.class)).explainEndpointJson(this.getEndpointUri(), true);
    }

    public TabularData explain(boolean allOptions) {
        try {
            String json = ((CatalogCamelContext)this.endpoint.getCamelContext().adapt(CatalogCamelContext.class)).explainEndpointJson(this.getEndpointUri(), allOptions);
            List rows = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainEndpointTabularType());
            for (Map row : rows) {
                String name = (String)row.get("name");
                String kind = (String)row.get("kind");
                String group = row.get("group") != null ? (String)row.get("group") : "";
                String label = row.get("label") != null ? (String)row.get("label") : "";
                String type = (String)row.get("type");
                String javaType = (String)row.get("javaType");
                String deprecated = row.get("deprecated") != null ? (String)row.get("deprecated") : "";
                String secret = row.get("secret") != null ? (String)row.get("secret") : "";
                String value = row.get("value") != null ? (String)row.get("value") : "";
                String defaultValue = row.get("defaultValue") != null ? (String)row.get("defaultValue") : "";
                String description = row.get("description") != null ? (String)row.get("description") : "";
                CompositeType ct = CamelOpenMBeanTypes.explainEndpointsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "group", "label", "type", "java type", "deprecated", "secret", "value", "default value", "description"}, new Object[]{name, kind, group, label, type, javaType, deprecated, secret, value, defaultValue, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Endpoint getInstance() {
        return this.endpoint;
    }
}

