/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.http.common.HttpHeaderFilterStrategy;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJettyHttpBinding
implements JettyHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();
    private boolean throwExceptionOnFailure;
    private boolean transferException;
    private boolean allowJavaSerializedObject;
    private String okStatusCodeRange;

    @Override
    public void populateResponse(Exchange exchange, JettyContentExchange httpExchange) throws Exception {
        int responseCode = httpExchange.getResponseStatus();
        LOG.debug("HTTP responseCode: {}", (Object)responseCode);
        Message in = exchange.getIn();
        if (!this.isThrowExceptionOnFailure()) {
            this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
        } else {
            boolean ok = HttpHelper.isStatusCodeOk((int)responseCode, (String)this.okStatusCodeRange);
            if (ok) {
                this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
            } else {
                Exception ex = this.populateHttpOperationFailedException(exchange, httpExchange, responseCode);
                if (ex != null) {
                    throw ex;
                }
                this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
            }
        }
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    @Override
    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    @Override
    public boolean isTransferException() {
        return this.transferException;
    }

    @Override
    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    @Override
    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    @Override
    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }

    @Override
    public String getOkStatusCodeRange() {
        return this.okStatusCodeRange;
    }

    @Override
    public void setOkStatusCodeRange(String okStatusCodeRange) {
        this.okStatusCodeRange = okStatusCodeRange;
    }

    protected void populateResponse(Exchange exchange, JettyContentExchange httpExchange, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Message answer = exchange.getOut();
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        Map<String, Collection<String>> headers = httpExchange.getResponseHeaders();
        for (Map.Entry<String, Collection<String>> ent : headers.entrySet()) {
            String name = ent.getKey();
            Collection<String> values = ent.getValue();
            for (String value : values) {
                if (name.toLowerCase().equals("content-type")) {
                    name = "Content-Type";
                    exchange.setProperty("CamelCharsetName", (Object)IOHelper.getCharsetNameFromContentType((String)value));
                }
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)value);
            }
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (HeaderFilterStrategy)this.httpProtocolHeaderFilterStrategy, (boolean)false);
        answer.setBody(this.extractResponseBody(exchange, httpExchange));
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, JettyContentExchange httpExchange, int responseCode) throws IOException {
        HttpOperationFailedException answer;
        String uri = httpExchange.getUrl();
        Map<String, String> headers = this.getSimpleMap(httpExchange.getResponseHeaders());
        Object responseBody = this.extractResponseBody(exchange, httpExchange);
        if (this.transferException && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        if (responseCode >= 300 && responseCode < 400) {
            Collection<String> loc = httpExchange.getResponseHeaders().get("location");
            if (loc != null && !loc.isEmpty()) {
                String locationHeader = loc.iterator().next();
                answer = new HttpOperationFailedException(uri, responseCode, null, locationHeader, headers, copy);
            } else {
                answer = new HttpOperationFailedException(uri, responseCode, null, null, headers, copy);
            }
        } else {
            answer = new HttpOperationFailedException(uri, responseCode, null, null, headers, copy);
        }
        return answer;
    }

    protected Object extractResponseBody(Exchange exchange, JettyContentExchange httpExchange) throws IOException {
        Map<String, String> headers = this.getSimpleMap(httpExchange.getResponseHeaders());
        String contentType = headers.get("Content-Type");
        if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
            if (this.isAllowJavaSerializedObject() || this.isTransferException()) {
                try {
                    InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)httpExchange.getResponseContentBytes());
                    return HttpHelper.deserializeJavaObjectFromStream((InputStream)is, (CamelContext)exchange.getContext());
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
                }
            }
            return null;
        }
        return httpExchange.getBody();
    }

    Map<String, String> getSimpleMap(Map<String, Collection<String>> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            Collection<String> valueCol = headers.get(key);
            String value = valueCol == null ? null : valueCol.iterator().next();
            result.put(key, value);
        }
        return result;
    }
}

