/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientListener
public class InfinispanRemoteEventListener
extends InfinispanEventListener {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public InfinispanRemoteEventListener(InfinispanConsumer infinispanConsumer, Set<String> eventTypes) {
        super(infinispanConsumer, eventTypes);
    }

    @ClientCacheEntryCreated
    public void processEvent(ClientCacheEntryCreatedEvent<Object> event) {
        this.logger.trace("Received ClientEvent [{}]", event);
        this.dispatch(event.getType().toString(), false, this.cacheName, event.getKey());
    }

    @ClientCacheEntryModified
    public void processEvent(ClientCacheEntryModifiedEvent<Object> event) {
        this.logger.trace("Received ClientEvent [{}]", event);
        this.dispatch(event.getType().toString(), false, this.cacheName, event.getKey());
    }

    @ClientCacheEntryRemoved
    public void processEvent(ClientCacheEntryRemovedEvent<Object> event) {
        this.logger.trace("Received ClientEvent [{}]", event);
        this.dispatch(event.getType().toString(), false, this.cacheName, event.getKey());
    }

    @ClientCacheFailover
    public void processEvent(ClientCacheFailoverEvent event) {
        this.logger.trace("Received ClientEvent [{}]", (Object)event);
        this.dispatch(event.getType().toString(), false, this.cacheName, null);
    }

    @ClientCacheEntryExpired
    public void processEvent(ClientCacheEntryExpiredEvent<Object> event) {
        this.logger.trace("Received ClientEvent [{}]", event);
        this.dispatch(event.getType().toString(), false, this.cacheName, event.getKey());
    }

    private void dispatch(String eventType, boolean isPre, String cacheName, Object key) {
        if (this.isAccepted(eventType)) {
            this.infinispanConsumer.processEvent(eventType, isPre, cacheName, key, null);
        }
    }
}

