/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.catalog.AbstractCamelCatalog;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CamelCatalogJSonSchemaResolver;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.DefaultVersionManager;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionHelper;
import org.apache.camel.catalog.VersionManager;
import org.w3c.dom.Document;

public class DefaultCamelCatalog
extends AbstractCamelCatalog
implements CamelCatalog {
    private static final String MODELS_CATALOG = "org/apache/camel/catalog/models.properties";
    private static final String MODEL_DIR = "org/apache/camel/catalog/models";
    private static final String DOC_DIR = "org/apache/camel/catalog/docs";
    private static final String ARCHETYPES_CATALOG = "org/apache/camel/catalog/archetypes/archetype-catalog.xml";
    private static final String SCHEMAS_XML = "org/apache/camel/catalog/schemas";
    private final VersionHelper version = new VersionHelper();
    private final Map<String, String> extraComponents = new HashMap<String, String>();
    private final Map<String, String> extraComponentsJSonSchema = new HashMap<String, String>();
    private final Map<String, String> extraDataFormats = new HashMap<String, String>();
    private final Map<String, String> extraDataFormatsJSonSchema = new HashMap<String, String>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean caching;
    private VersionManager versionManager = new DefaultVersionManager(this);
    private RuntimeProvider runtimeProvider = new DefaultRuntimeProvider(this);

    public DefaultCamelCatalog() {
        this(false);
    }

    public DefaultCamelCatalog(boolean caching) {
        this.caching = caching;
        this.setJSonSchemaResolver(new CamelCatalogJSonSchemaResolver(this, this.extraComponents, this.extraComponentsJSonSchema, this.extraDataFormats, this.extraDataFormatsJSonSchema));
    }

    @Override
    public RuntimeProvider getRuntimeProvider() {
        return this.runtimeProvider;
    }

    @Override
    public void setRuntimeProvider(RuntimeProvider runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        this.runtimeProvider.setCamelCatalog(this);
        this.cache.remove("findComponentNames");
        this.cache.remove("listComponentsAsJson");
        this.cache.remove("findDataFormatNames");
        this.cache.remove("listDataFormatsAsJson");
        this.cache.remove("findLanguageNames");
        this.cache.remove("listLanguagesAsJson");
    }

    @Override
    public void enableCache() {
        this.caching = true;
    }

    @Override
    public boolean isCaching() {
        return this.caching;
    }

    @Override
    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    public void addComponent(String name, String className) {
        this.extraComponents.put(name, className);
        this.cache.remove("findComponentNames");
        this.cache.remove("findComponentLabels");
        this.cache.remove("listComponentsAsJson");
    }

    @Override
    public void addComponent(String name, String className, String jsonSchema) {
        this.addComponent(name, className);
        if (jsonSchema != null) {
            this.extraComponentsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public void addDataFormat(String name, String className) {
        this.extraDataFormats.put(name, className);
        this.cache.remove("findDataFormatNames");
        this.cache.remove("findDataFormatLabels");
        this.cache.remove("listDataFormatsAsJson");
    }

    @Override
    public void addDataFormat(String name, String className, String jsonSchema) {
        this.addDataFormat(name, className);
        if (jsonSchema != null) {
            this.extraDataFormatsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public String getCatalogVersion() {
        return this.version.getVersion();
    }

    @Override
    public boolean loadVersion(String version) {
        if (version.equals(this.versionManager.getLoadedVersion())) {
            return true;
        }
        if (this.versionManager.loadVersion(version)) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public String getLoadedVersion() {
        return this.versionManager.getLoadedVersion();
    }

    @Override
    public String getRuntimeProviderLoadedVersion() {
        return this.versionManager.getRuntimeProviderLoadedVersion();
    }

    @Override
    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        return this.versionManager.loadRuntimeProviderVersion(groupId, artifactId, version);
    }

    @Override
    public List<String> findComponentNames() {
        List<String> names = null;
        if (this.caching) {
            names = (List<String>)this.cache.get("findComponentNames");
        }
        if (names == null) {
            names = this.runtimeProvider.findComponentNames();
            for (Map.Entry<String, String> entry : this.extraComponents.entrySet()) {
                names.add(entry.getKey());
            }
            Collections.sort(names);
            if (this.caching) {
                this.cache.put("findComponentNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findDataFormatNames() {
        List<String> names = null;
        if (this.caching) {
            names = (List<String>)this.cache.get("findDataFormatNames");
        }
        if (names == null) {
            names = this.runtimeProvider.findDataFormatNames();
            for (Map.Entry<String, String> entry : this.extraDataFormats.entrySet()) {
                names.add(entry.getKey());
            }
            Collections.sort(names);
            if (this.caching) {
                this.cache.put("findDataFormatNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findLanguageNames() {
        List<String> names = null;
        if (this.caching) {
            names = (List<String>)this.cache.get("findLanguageNames");
        }
        if (names == null) {
            names = this.runtimeProvider.findLanguageNames();
            if (this.caching) {
                this.cache.put("findLanguageNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames() {
        ArrayList<String> names = null;
        if (this.caching) {
            names = (ArrayList<String>)this.cache.get("findModelNames");
        }
        if (names == null) {
            names = new ArrayList<String>();
            InputStream is = this.versionManager.getResourceAsStream(MODELS_CATALOG);
            if (is != null) {
                try {
                    CatalogHelper.loadLines(is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("findModelNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findOtherNames() {
        List<String> names = null;
        if (this.caching) {
            names = (List<String>)this.cache.get("findOtherNames");
        }
        if (names == null) {
            names = this.runtimeProvider.findOtherNames();
            if (this.caching) {
                this.cache.put("findOtherNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findModelNames();
        for (String name : names) {
            String json = this.modelJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findComponentNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findComponentNames();
        for (String name : names) {
            String json = this.componentJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findDataFormatNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findDataFormatNames();
        for (String name : names) {
            String json = this.dataFormatJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findLanguageNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findLanguageNames();
        for (String name : names) {
            String json = this.languageJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findOtherNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findOtherNames();
        for (String name : names) {
            String json = this.otherJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("other", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public String modelJSonSchema(String name) {
        String file = "org/apache/camel/catalog/models/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("model-" + file);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getModelJSonSchema(name);
            if (this.caching) {
                this.cache.put("model-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String componentJSonSchema(String name) {
        String file = this.runtimeProvider.getComponentJSonSchemaDirectory() + "/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + file);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getComponentJSonSchema(name);
            if (this.caching) {
                this.cache.put("component-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        String file = this.runtimeProvider.getDataFormatJSonSchemaDirectory() + "/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + file);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getDataFormatJSonSchema(name);
            if (this.caching) {
                this.cache.put("dataformat-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String languageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = this.runtimeProvider.getLanguageJSonSchemaDirectory() + "/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("language-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String otherJSonSchema(String name) {
        String file = this.runtimeProvider.getOtherJSonSchemaDirectory() + "/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("other-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("other-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String componentAsciiDoc(String name) {
        String answer = this.doComponentAsciiDoc(name);
        if (answer == null) {
            List<String> names = this.findComponentNames();
            for (String alternative : names) {
                String schemes = this.getAlternativeComponentName(alternative);
                if (schemes == null || !schemes.contains(name)) continue;
                String first = schemes.split(",")[0];
                return this.componentAsciiDoc(first);
            }
        }
        return answer;
    }

    @Override
    public String componentHtmlDoc(String name) {
        String answer = this.doComponentHtmlDoc(name);
        if (answer == null) {
            List<String> names = this.findComponentNames();
            for (String alternative : names) {
                String schemes = this.getAlternativeComponentName(alternative);
                if (schemes == null || !schemes.contains(name)) continue;
                String first = schemes.split(",")[0];
                return this.componentHtmlDoc(first);
            }
        }
        return answer;
    }

    private String getAlternativeComponentName(String componentName) {
        String json = this.componentJSonSchema(componentName);
        if (json != null) {
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            for (Map<String, String> row : rows) {
                if (!row.containsKey("alternativeSchemes")) continue;
                return row.get("alternativeSchemes");
            }
        }
        return null;
    }

    private String doComponentAsciiDoc(String name) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            name = "mail";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-component.adoc";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {}
            } else {
                String className = this.extraComponents.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    String path = (packageName = packageName.replace('.', '/')) + "/" + name + "-component.adoc";
                    is = this.versionManager.getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("component-" + file, answer);
            }
        }
        return answer;
    }

    private String doComponentHtmlDoc(String name) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            name = "mail";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-component.html";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {}
            } else {
                String className = this.extraComponents.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    String path = (packageName = packageName.replace('.', '/')) + "/" + name + "-component.html";
                    is = this.versionManager.getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("component-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String dataFormatAsciiDoc(String name) {
        if (name.startsWith("bindy")) {
            name = "bindy";
        } else if (name.startsWith("univocity")) {
            name = "univocity";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-dataformat.adoc";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {}
            } else {
                String className = this.extraDataFormats.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    String path = (packageName = packageName.replace('.', '/')) + "/" + name + "-dataformat.adoc";
                    is = this.versionManager.getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("dataformat-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String dataFormatHtmlDoc(String name) {
        if (name.startsWith("bindy")) {
            name = "bindy";
        } else if (name.startsWith("univocity")) {
            name = "univocity";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-dataformat.html";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {}
            } else {
                String className = this.extraDataFormats.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    String path = (packageName = packageName.replace('.', '/')) + "/" + name + "-dataformat.html";
                    is = this.versionManager.getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("dataformat-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String languageAsciiDoc(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-language.adoc";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("language-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String languageHtmlDoc(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-language.html";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("language-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String otherAsciiDoc(String name) {
        String file = "org/apache/camel/catalog/docs/" + name + ".adoc";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("other-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("other-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String otherHtmlDoc(String name) {
        String file = "org/apache/camel/catalog/docs/" + name + "-other.html";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("language-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findModelLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findModelLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findModelNames();
            for (String name : names) {
                String json = this.modelJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findModelLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findComponentLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findComponentLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findComponentNames();
            for (String name : names) {
                String json = this.componentJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findComponentLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findDataFormatLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findDataFormatLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findDataFormatNames();
            for (String name : names) {
                String json = this.dataFormatJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findDataFormatLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findLanguageLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findLanguageLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findLanguageNames();
            for (String name : names) {
                String json = this.languageJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findLanguageLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findOtherLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findOtherLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findOtherNames();
            for (String name : names) {
                String json = this.otherJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("other", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findOtherLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public String archetypeCatalogAsXml() {
        String file = ARCHETYPES_CATALOG;
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    @Override
    public String springSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-spring.xsd";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    @Override
    public String blueprintSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-blueprint.xsd";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = this.versionManager.getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    private Map<String, String> filterProperties(String scheme, Map<String, String> options) {
        String showAll;
        if ("log".equals(scheme) && "true".equals(showAll = options.get("showAll"))) {
            LinkedHashMap<String, String> filtered = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                boolean skip = key.startsWith("show") && !key.equals("showAll");
                if (skip) continue;
                filtered.put(key, entry.getValue());
            }
            return filtered;
        }
        return options;
    }

    @Override
    public String listComponentsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listComponentsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findComponentNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.componentJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"component\": {", "\"componentProperties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listComponentsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listDataFormatsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listDataFormatsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findDataFormatNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.dataFormatJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"dataformat\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listDataFormatsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listLanguagesAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listLanguagesAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findLanguageNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.languageJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"language\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listLanguagesAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listModelsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listModelsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findModelNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.modelJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"model\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listModelsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listOthersAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listOthersAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findOtherNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.otherJSonSchema(scheme);
                json = (json = CatalogHelper.between(json, "\"other\": {", "  }")) != null ? json.trim() : "";
                json = json + "\n  },";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listOthersAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String summaryAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("summaryAsJson");
        }
        if (answer == null) {
            int archetypes = 0;
            try {
                String xml = this.archetypeCatalogAsXml();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                Document dom = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
                Object val = XPathFactory.newInstance().newXPath().evaluate("count(/archetype-catalog/archetypes/archetype)", dom, XPathConstants.NUMBER);
                double num = (Double)val;
                archetypes = (int)num;
            }
            catch (Exception xml) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            sb.append("  \"version\": \"").append(this.getCatalogVersion()).append("\",\n");
            sb.append("  \"eips\": ").append(this.findModelNames().size()).append(",\n");
            sb.append("  \"components\": ").append(this.findComponentNames().size()).append(",\n");
            sb.append("  \"dataformats\": ").append(this.findDataFormatNames().size()).append(",\n");
            sb.append("  \"languages\": ").append(this.findLanguageNames().size()).append(",\n");
            sb.append("  \"archetypes\": ").append(archetypes).append("\n");
            sb.append("}");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("summaryAsJson", answer);
            }
        }
        return answer;
    }
}

