/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pdf.PdfConfiguration;
import org.apache.camel.component.pdf.PdfProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.16.0", scheme="pdf", title="PDF", syntax="pdf:operation", producerOnly=true, label="document,transformation,printing")
public class PdfEndpoint
extends DefaultEndpoint {
    @UriParam
    private PdfConfiguration pdfConfiguration;

    public PdfEndpoint(String endpointUri, Component component, PdfConfiguration pdfConfiguration) {
        super(endpointUri, component);
        this.pdfConfiguration = pdfConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new PdfProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer does not supported for PDF component:" + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public PdfConfiguration getPdfConfiguration() {
        return this.pdfConfiguration;
    }

    public void setPdfConfiguration(PdfConfiguration pdfConfiguration) {
        this.pdfConfiguration = pdfConfiguration;
    }
}

