/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.drill;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import oadd.org.apache.commons.lang.StringUtils;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.drill.DrillComponent;
import org.apache.camel.component.drill.DrillConnectionMode;
import org.apache.camel.component.drill.DrillProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultPollingEndpoint;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;

@UriEndpoint(firstVersion="2.19.0", scheme="drill", title="Drill", syntax="drill:host", producerOnly=true, label="database,sql")
public class DrillEndpoint
extends DefaultPollingEndpoint {
    @UriPath(description="Host name or IP address")
    @Metadata(required=true)
    private String host;
    @UriParam(description="Port number")
    @Metadata(required=false, defaultValue="2181")
    private Integer port = 2181;
    @UriParam(description="Drill directory", defaultValue="")
    private String directory = "";
    @UriParam(defaultValue="")
    private String clusterId = "";
    @UriParam(defaultValue="ZK", enums="ZK,DRILLBIT")
    private DrillConnectionMode mode = DrillConnectionMode.ZK;

    public DrillEndpoint(String uri, DrillComponent component) {
        super(uri, (Component)component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("DrillConsumer is not supported!");
    }

    public Producer createProducer() throws Exception {
        return new DrillProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    public String toJDBCUri() {
        String url = "jdbc:drill:" + this.mode.name().toLowerCase() + "=" + this.host + ":" + this.port;
        if (this.mode.equals((Object)DrillConnectionMode.ZK)) {
            if (StringUtils.isNotBlank((String)this.directory)) {
                url = url + "/" + this.directory;
            }
            if (StringUtils.isNotBlank((String)this.clusterId)) {
                url = url + "/" + this.clusterId;
            }
        }
        return url;
    }

    public List<?> queryForList(ResultSet rs) throws SQLException {
        ColumnMapRowMapper rowMapper = new ColumnMapRowMapper();
        RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)rowMapper);
        List data = mapper.extractData(rs);
        return data;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public DrillConnectionMode getMode() {
        return this.mode;
    }

    public void setMode(DrillConnectionMode mode) {
        this.mode = mode;
    }
}

