/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.builder.PortBuilder;

public class PortProducer
extends AbstractOpenstackProducer {
    public PortProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Port in = this.messageToPort(exchange.getIn());
        Port out = this.os.networking().port().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("portId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Port ID");
        Port result = this.os.networking().port().get(id);
        msg.setBody((Object)result);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.networking().port().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Port port = this.messageToPort(msg);
        Port updatedPort = this.os.networking().port().update(port);
        msg.setBody((Object)updatedPort);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("portId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Port ID");
        ActionResponse response = this.os.networking().port().delete(id);
        this.checkFailure(response, msg, "Delete port with ID " + id);
    }

    private Port messageToPort(Message message) {
        Port port = (Port)message.getBody(Port.class);
        if (port == null) {
            Map headers = message.getHeaders();
            PortBuilder builder = Builders.port();
            StringHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("tenantId")) {
                builder.tenantId((String)message.getHeader("tenantId", String.class));
            }
            if (headers.containsKey("networkId")) {
                builder.networkId((String)message.getHeader("networkId", String.class));
            }
            if (headers.containsKey("deviceId")) {
                builder.deviceId((String)message.getHeader("deviceId", String.class));
            }
            if (headers.containsKey("macAddress")) {
                builder.macAddress((String)message.getHeader("macAddress", String.class));
            }
            port = (Port)builder.build();
        }
        return port;
    }
}

