/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import java.time.Duration;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class NatsProducer
extends DefaultProducer {
    private Connection connection;

    public NatsProducer(NatsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        NatsConfiguration config = this.getEndpoint().getNatsConfiguration();
        String body = (String)exchange.getIn().getMandatoryBody(String.class);
        this.log.debug("Publishing to topic: {}", (Object)config.getTopic());
        if (ObjectHelper.isNotEmpty((Object)config.getReplySubject())) {
            String replySubject = config.getReplySubject();
            this.connection.publish(config.getTopic(), replySubject, body.getBytes());
        } else {
            this.connection.publish(config.getTopic(), body.getBytes());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.debug("Starting Nats Producer");
        this.log.debug("Getting Nats Connection");
        this.connection = this.getEndpoint().getNatsConfiguration().getConnection() != null ? this.getEndpoint().getNatsConfiguration().getConnection() : this.getEndpoint().getConnection();
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping Nats Producer");
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getNatsConfiguration().getConnection())) {
            this.log.debug("Closing Nats Connection");
            if (this.connection != null && !this.connection.getStatus().equals((Object)Connection.Status.CLOSED)) {
                if (this.getEndpoint().getNatsConfiguration().isFlushConnection()) {
                    this.log.debug("Flushing Nats Connection");
                    this.connection.flush(Duration.ofMillis(this.getEndpoint().getNatsConfiguration().getFlushTimeout()));
                }
                this.connection.close();
            }
        }
        super.doStop();
    }
}

