/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerConfiguration;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.sig.SignerInfo;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SignedDataCreatorConfiguration
extends CryptoCmsMarshallerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDataCreatorConfiguration.class);
    @UriParam(label="sign", defaultValue="true")
    private Boolean includeContent = Boolean.TRUE;
    @UriParam(label="sign", multiValue=true, description="Signer information: reference to a bean which implements org.apache.camel.component.crypto.cms.api.SignerInfo")
    private final List<SignerInfo> signer = new ArrayList<SignerInfo>(3);

    public SignedDataCreatorConfiguration(CamelContext context) {
        super(context);
    }

    public Boolean getIncludeContent() {
        return this.includeContent;
    }

    public void setIncludeContent(Boolean includeContent) {
        this.includeContent = includeContent;
    }

    public List<SignerInfo> getSigner() {
        return this.signer;
    }

    public void setSigner(SignerInfo signer) {
        this.signer.add(signer);
    }

    public void setSigner(List<?> signers) {
        if (signers == null) {
            return;
        }
        for (Object signerOb : signers) {
            SignerInfo signer;
            if (!(signerOb instanceof String)) continue;
            String signerName = (String)signerOb;
            String valueNoHash = signerName.replaceAll("#", "");
            if (this.getContext() == null || signerName == null || (signer = (SignerInfo)this.getContext().getRegistry().lookupByNameAndType(valueNoHash, SignerInfo.class)) == null) continue;
            this.setSigner(signer);
        }
    }

    public void init() throws CryptoCmsException {
        if (this.signer.isEmpty()) {
            this.logErrorAndThrow(LOG, "No signer set.");
        }
    }
}

