/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms;

import java.net.MalformedURLException;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.crypto.cms.CryptoCmsEndpoint;
import org.apache.camel.component.crypto.cms.CryptoOperation;
import org.apache.camel.component.crypto.cms.crypt.DefaultEnvelopedDataDecryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataDecryptor;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataDecryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataEncryptor;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataEncryptorConfiguration;
import org.apache.camel.component.crypto.cms.sig.DefaultSignedDataVerifierConfiguration;
import org.apache.camel.component.crypto.cms.sig.SignedDataCreator;
import org.apache.camel.component.crypto.cms.sig.SignedDataCreatorConfiguration;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifierConfiguration;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifierFromHeader;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@Component(value="crypto-cms")
public class CryptoCmsComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private SignedDataVerifierConfiguration signedDataVerifierConfiguration;
    @Metadata(label="advanced")
    private EnvelopedDataDecryptorConfiguration envelopedDataDecryptorConfiguration;

    public CryptoCmsComponent() {
    }

    public CryptoCmsComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object processor;
        Object config;
        CryptoOperation operation;
        String name;
        String scheme;
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
        try {
            URI u = new URI(remaining);
            scheme = u.getScheme();
            name = u.getPath();
        }
        catch (Exception e) {
            throw new MalformedURLException(String.format("An invalid crypto-cms uri was provided '%s'. Check that the uri matches the format crypto-cms:sign://<name>, crypto-cms:verify://<name>, crypto-cms:encrypt://<name>, or crypto-cms:decrpyt://<name>", uri));
        }
        if (CryptoOperation.sign.name().equals(scheme)) {
            operation = CryptoOperation.sign;
            config = new SignedDataCreatorConfiguration(this.getCamelContext());
            this.setProperties(config, parameters);
            ((SignedDataCreatorConfiguration)config).init();
            processor = new SignedDataCreator((SignedDataCreatorConfiguration)config);
        } else if (CryptoOperation.verify.name().equals(scheme)) {
            operation = CryptoOperation.verify;
            config = this.getSignedDataVerifierConfiguration().copy();
            this.setProperties(config, parameters);
            processor = new SignedDataVerifierFromHeader((SignedDataVerifierConfiguration)config);
        } else if (CryptoOperation.encrypt.name().equals(scheme)) {
            operation = CryptoOperation.encrypt;
            config = new EnvelopedDataEncryptorConfiguration(this.getCamelContext());
            this.setProperties(config, parameters);
            ((EnvelopedDataEncryptorConfiguration)config).init();
            processor = new EnvelopedDataEncryptor((EnvelopedDataEncryptorConfiguration)config);
        } else if (CryptoOperation.decrypt.name().equals(scheme)) {
            operation = CryptoOperation.decrypt;
            config = this.getEnvelopedDataDecryptorConfiguration().copy();
            this.setProperties(config, parameters);
            processor = new EnvelopedDataDecryptor((EnvelopedDataDecryptorConfiguration)config);
        } else {
            String error = "Endpoint uri " + uri + " is wrong configured. Operation " + scheme + " is not supported. Supported operations are: sign, verify, encrypt, decrypt";
            this.log.error(error);
            throw new IllegalStateException(error);
        }
        CryptoCmsEndpoint endpoint = new CryptoCmsEndpoint(uri, this, (Processor)processor);
        endpoint.setCryptoOperation(operation);
        endpoint.setName(name);
        return endpoint;
    }

    public void setSignedDataVerifierConfiguration(SignedDataVerifierConfiguration signedDataVerifierConfiguration) {
        this.signedDataVerifierConfiguration = signedDataVerifierConfiguration;
    }

    public SignedDataVerifierConfiguration getSignedDataVerifierConfiguration() {
        if (this.signedDataVerifierConfiguration == null) {
            this.signedDataVerifierConfiguration = new DefaultSignedDataVerifierConfiguration();
        }
        return this.signedDataVerifierConfiguration;
    }

    public EnvelopedDataDecryptorConfiguration getEnvelopedDataDecryptorConfiguration() {
        if (this.envelopedDataDecryptorConfiguration == null) {
            this.envelopedDataDecryptorConfiguration = new DefaultEnvelopedDataDecryptorConfiguration();
        }
        return this.envelopedDataDecryptorConfiguration;
    }

    public void setEnvelopedDataDecryptorConfiguration(EnvelopedDataDecryptorConfiguration envelopedDataDecryptorConfiguration) {
        this.envelopedDataDecryptorConfiguration = envelopedDataDecryptorConfiguration;
    }

    protected void doStart() throws Exception {
        if (Security.getProvider("BC") == null) {
            this.log.debug("Adding BouncyCastleProvider as security provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        super.doStart();
    }
}

