/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.model.Record;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.aws.kinesis.RecordStringConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class RecordStringConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(1);

    private void registerConverters() {
        this.converters.put(String.class, Record.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return RecordStringConverter.toString((Record)value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        try {
            this.registerConverters();
            this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

