/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stomp.StompComponent;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.component.stomp.StompConsumer;
import org.apache.camel.component.stomp.StompProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.CallbackConnection;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.client.Promise;
import org.fusesource.stomp.client.Stomp;
import org.fusesource.stomp.codec.StompFrame;

@UriEndpoint(firstVersion="2.12.0", scheme="stomp", title="Stomp", syntax="stomp:destination", label="messaging")
public class StompEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    @UriPath(description="Name of the queue")
    @Metadata(required=true)
    private String destination;
    @UriParam
    private StompConfiguration configuration;
    private CallbackConnection connection;
    private Stomp stomp;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;
    private final List<StompConsumer> consumers = new CopyOnWriteArrayList<StompConsumer>();

    public StompEndpoint(String uri, StompComponent component, StompConfiguration configuration, String destination) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.destination = destination;
    }

    public Producer createProducer() throws Exception {
        return new StompProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new StompConsumer((Endpoint)this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        Promise promise = new Promise();
        this.stomp = new Stomp(this.configuration.getBrokerURL());
        this.stomp.setLogin(this.configuration.getLogin());
        this.stomp.setPasscode(this.configuration.getPasscode());
        if (this.configuration.getSslContextParameters() != null) {
            this.stomp.setSslContext(this.configuration.getSslContextParameters().createSSLContext(this.getCamelContext()));
        }
        this.stomp.connectCallback((Callback)promise);
        if (this.configuration.getHost() != null && !this.configuration.getHost().isEmpty()) {
            this.stomp.setHost(this.configuration.getHost());
        }
        this.connection = (CallbackConnection)promise.await();
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompEndpoint.this.connection.receive((Callback)new Callback<StompFrame>(){

                    public void onFailure(Throwable value) {
                        if (StompEndpoint.this.isStarted()) {
                            StompEndpoint.this.connection.close(null);
                        }
                    }

                    public void onSuccess(StompFrame value) {
                        if (!StompEndpoint.this.consumers.isEmpty()) {
                            Exchange exchange = StompEndpoint.this.createExchange();
                            exchange.getIn().setBody((Object)value.content());
                            for (StompConsumer consumer : StompEndpoint.this.consumers) {
                                consumer.processExchange(exchange);
                            }
                        }
                    }
                });
                StompEndpoint.this.connection.resume();
            }
        });
    }

    protected void doStop() throws Exception {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.DISCONNECT);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.connection.close(null);
    }

    protected void send(final Exchange exchange, final AsyncCallback callback) {
        final StompFrame frame = new StompFrame(Constants.SEND);
        this.populateCamelMessageHeadersToStompFrames(exchange, frame);
        frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)this.destination));
        frame.content((Buffer)UTF8Buffer.utf8((String)((String)exchange.getIn().getBody(String.class))));
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompEndpoint.this.connection.send(frame, (Callback)new Callback<Void>(){

                    public void onFailure(Throwable e) {
                        exchange.setException(e);
                        callback.done(false);
                    }

                    public void onSuccess(Void v) {
                        callback.done(false);
                    }
                });
            }
        });
    }

    private void populateCamelMessageHeadersToStompFrames(Exchange exchange, StompFrame frame) {
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerName.toLowerCase().startsWith("camel") || this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange) || headerValue == null) continue;
            frame.addHeader(new AsciiBuffer(headerName), StompFrame.encodeHeader((String)headerValue.toString()));
        }
    }

    void addConsumer(final StompConsumer consumer) {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.SUBSCRIBE);
                frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)StompEndpoint.this.destination));
                frame.addHeader(Constants.ID, consumer.id);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.consumers.add(consumer);
    }

    void removeConsumer(final StompConsumer consumer) {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.UNSUBSCRIBE);
                frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)StompEndpoint.this.destination));
                frame.addHeader(Constants.ID, consumer.id);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.consumers.remove((Object)consumer);
    }

    AsciiBuffer getNextId() {
        return this.connection.nextId();
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

