/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.util.Map;
import javax.xml.crypto.URIDereferencer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlsecurity.XmlCommand;
import org.apache.camel.component.xmlsecurity.XmlSignatureComponent;
import org.apache.camel.component.xmlsecurity.XmlSignatureProducer;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.12.0", scheme="xmlsecurity", title="XML Security", syntax="xmlsecurity:command:name", producerOnly=true, label="security,transformation")
public abstract class XmlSignatureEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private XmlCommand command;
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam
    private XmlSignerConfiguration signerConfiguration;
    @UriParam
    private XmlVerifierConfiguration verifierConfiguration;

    public XmlSignatureEndpoint(String uri, XmlSignatureComponent component) {
        super(uri, (Component)component);
    }

    public XmlCommand getCommand() {
        return this.command;
    }

    public void setCommand(XmlCommand command) {
        this.command = command;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Producer createProducer() {
        return new XmlSignatureProducer((Endpoint)this, this.createProcessor());
    }

    abstract Processor createProcessor();

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("XML Signature endpoints are not meant to be consumed from.");
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getManagedObject(XmlSignatureEndpoint endpoint) {
        return this;
    }

    public abstract XmlSignatureConfiguration getConfiguration();

    public URIDereferencer getUriDereferencer() {
        return this.getConfiguration().getUriDereferencer();
    }

    public void setUriDereferencer(URIDereferencer uriDereferencer) {
        this.getConfiguration().setUriDereferencer(uriDereferencer);
    }

    public String getBaseUri() {
        return this.getConfiguration().getBaseUri();
    }

    public void setBaseUri(String baseUri) {
        this.getConfiguration().setBaseUri(baseUri);
    }

    public Map<String, ? extends Object> getCryptoContextProperties() {
        return this.getConfiguration().getCryptoContextProperties();
    }

    public void setCryptoContextProperties(Map<String, ? extends Object> cryptoContextProperties) {
        this.getConfiguration().setCryptoContextProperties(cryptoContextProperties);
    }

    public Boolean getDisallowDoctypeDecl() {
        return this.getConfiguration().getDisallowDoctypeDecl();
    }

    public void setDisallowDoctypeDecl(Boolean disallowDoctypeDecl) {
        this.getConfiguration().setDisallowDoctypeDecl(disallowDoctypeDecl);
    }

    public Boolean getOmitXmlDeclaration() {
        return this.getConfiguration().getOmitXmlDeclaration();
    }

    public void setOmitXmlDeclaration(Boolean omitXmlDeclaration) {
        this.getConfiguration().setOmitXmlDeclaration(omitXmlDeclaration);
    }

    public String getSchemaResourceUri() {
        return this.getConfiguration().getSchemaResourceUri();
    }

    public void setSchemaResourceUri(String schemaResourceUri) {
        this.getConfiguration().setSchemaResourceUri(schemaResourceUri);
    }

    public String getOutputXmlEncoding() {
        return this.getConfiguration().getOutputXmlEncoding();
    }

    public void setOutputXmlEncoding(String encoding) {
        this.getConfiguration().setOutputXmlEncoding(encoding);
    }
}

