/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.LoadPropertiesException;
import org.apache.camel.TypeConverter;
import org.apache.camel.blueprint.BlueprintCamelStateService;
import org.apache.camel.blueprint.BlueprintComponentResolver;
import org.apache.camel.blueprint.BlueprintContainerBeanRepository;
import org.apache.camel.blueprint.BlueprintDataFormatResolver;
import org.apache.camel.blueprint.BlueprintLanguageResolver;
import org.apache.camel.blueprint.BlueprintModelJAXBContextFactory;
import org.apache.camel.blueprint.handler.CamelNamespaceHandler;
import org.apache.camel.core.osgi.OsgiBeanRepository;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

public class BlueprintCamelContext
extends DefaultCamelContext
implements ServiceListener,
BlueprintListener {
    protected final AtomicBoolean routeDefinitionValid = new AtomicBoolean(true);
    private BundleContext bundleContext;
    private BlueprintContainer blueprintContainer;
    private ServiceRegistration<?> registration;
    private BlueprintCamelStateService bundleStateService;

    public BlueprintCamelContext(BundleContext bundleContext, BlueprintContainer blueprintContainer) {
        super(false);
        this.bundleContext = bundleContext;
        this.blueprintContainer = blueprintContainer;
        OsgiCamelContextHelper.osgiUpdate((DefaultCamelContext)this, (BundleContext)bundleContext);
        BlueprintContainerBeanRepository repo1 = new BlueprintContainerBeanRepository(this.getBlueprintContainer());
        OsgiBeanRepository repo2 = new OsgiBeanRepository(bundleContext);
        this.setRegistry((Registry)new DefaultRegistry(new BeanRepository[]{repo1, repo2}));
        this.addLifecycleStrategy((LifecycleStrategy)repo2);
        this.setComponentResolver((ComponentResolver)new BlueprintComponentResolver(bundleContext));
        this.setLanguageResolver((LanguageResolver)new BlueprintLanguageResolver(bundleContext));
        this.setDataFormatResolver((DataFormatResolver)new BlueprintDataFormatResolver(bundleContext));
        this.setApplicationContextClassLoader((ClassLoader)new BundleDelegatingClassLoader(bundleContext.getBundle()));
        this.init();
    }

    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new BlueprintModelJAXBContextFactory(CamelNamespaceHandler.class.getClassLoader());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public BlueprintCamelStateService getBundleStateService() {
        return this.bundleStateService;
    }

    public void setBundleStateService(BlueprintCamelStateService bundleStateService) {
        this.bundleStateService = bundleStateService;
    }

    public void doInit() {
        this.log.trace("init {}", (Object)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.registration = this.bundleContext.registerService(BlueprintListener.class, (Object)this, null);
        super.doInit();
    }

    public void destroy() throws Exception {
        this.log.trace("destroy {}", (Object)this);
        try {
            this.bundleContext.removeServiceListener((ServiceListener)this);
        }
        catch (Exception e) {
            this.log.warn("Error removing ServiceListener: " + (Object)((Object)this) + ". This exception is ignored.", (Throwable)e);
        }
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (Exception e) {
                this.log.warn("Error unregistering service registration: " + this.registration + ". This exception is ignored.", (Throwable)e);
            }
            this.registration = null;
        }
        this.bundleStateService.setBundleState(this.bundleContext.getBundle(), this.getName(), null);
        this.stop();
    }

    public Map<String, Properties> findComponents() throws LoadPropertiesException, IOException {
        return BundleContextUtils.findComponents((BundleContext)this.bundleContext, (CamelContext)this);
    }

    public void blueprintEvent(BlueprintEvent event) {
        if (this.log.isDebugEnabled()) {
            String eventTypeString;
            switch (event.getType()) {
                case 1: {
                    eventTypeString = "CREATING";
                    break;
                }
                case 2: {
                    eventTypeString = "CREATED";
                    break;
                }
                case 3: {
                    eventTypeString = "DESTROYING";
                    break;
                }
                case 4: {
                    eventTypeString = "DESTROYED";
                    break;
                }
                case 6: {
                    eventTypeString = "GRACE_PERIOD";
                    break;
                }
                case 7: {
                    eventTypeString = "WAITING";
                    break;
                }
                case 5: {
                    eventTypeString = "FAILURE";
                    break;
                }
                default: {
                    eventTypeString = "UNKNOWN";
                }
            }
            this.log.debug("Received BlueprintEvent[replay={} type={} bundle={}] %s", new Object[]{event.isReplay(), eventTypeString, event.getBundle().getSymbolicName(), event});
        }
        if (!event.isReplay() && this.getBundleContext().getBundle().getBundleId() == event.getBundle().getBundleId()) {
            if (event.getType() == 2) {
                try {
                    this.log.info("Attempting to start CamelContext: {}", (Object)this.getName());
                    this.maybeStart();
                }
                catch (Exception startEx) {
                    this.log.error("Error occurred during starting CamelContext: {}", (Object)this.getName(), (Object)startEx);
                }
            } else if (event.getType() == 3) {
                try {
                    this.log.info("Stopping CamelContext: {}", (Object)this.getName());
                    this.stop();
                }
                catch (Exception stopEx) {
                    this.log.error("Error occurred during stopping CamelContext: {}", (Object)this.getName(), (Object)stopEx);
                }
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.log.isTraceEnabled()) {
            String eventTypeString;
            switch (event.getType()) {
                case 1: {
                    eventTypeString = "REGISTERED";
                    break;
                }
                case 2: {
                    eventTypeString = "MODIFIED";
                    break;
                }
                case 4: {
                    eventTypeString = "UNREGISTERING";
                    break;
                }
                case 8: {
                    eventTypeString = "MODIFIED_ENDMATCH";
                    break;
                }
                default: {
                    eventTypeString = "UNKNOWN";
                }
            }
            this.log.trace("Service: {} changed to: {}", (Object)event, (Object)eventTypeString);
        }
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, (CamelContext)this, this.getInjector(), finder);
    }

    public void start() throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getApplicationContextClassLoader());
            this.bundleStateService.setBundleState(this.bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Starting);
            super.start();
            this.bundleStateService.setBundleState(this.bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Active);
        }
        catch (Exception e) {
            this.bundleStateService.setBundleState(this.bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Failure, e);
            this.routeDefinitionValid.set(false);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void maybeStart() throws Exception {
        boolean skip;
        this.log.trace("maybeStart: {}", (Object)this);
        if (!this.routeDefinitionValid.get()) {
            this.log.trace("maybeStart: {} is skipping since CamelRoute definition is not correct.", (Object)this);
            return;
        }
        boolean eager = "true".equalsIgnoreCase(System.getProperty("registerBlueprintCamelContextEager"));
        if (eager) {
            for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
                if (!(notifier instanceof OsgiCamelContextPublisher)) continue;
                OsgiCamelContextPublisher publisher = (OsgiCamelContextPublisher)notifier;
                publisher.registerCamelContext((CamelContext)this);
                break;
            }
        }
        if (skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            this.log.trace("maybeStart: {} is skipping as System property skipStartingCamelContext is set", (Object)this);
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            this.log.debug("Starting {}", (Object)this);
            this.start();
        } else {
            this.log.trace("Ignoring maybeStart() as {} is already started", (Object)this);
        }
    }
}

