/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.jgroups.raft.RaftHandle;

public class JGroupsRaftProducer
extends DefaultProducer {
    private final JGroupsRaftEndpoint endpoint;
    private final RaftHandle raftHandle;
    private final String clusterName;

    public JGroupsRaftProducer(JGroupsRaftEndpoint endpoint, RaftHandle raftHandle, String clusterName) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.raftHandle = raftHandle;
        this.clusterName = clusterName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect();
    }

    protected void doStop() throws Exception {
        this.endpoint.disconnect();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
        Integer setOffset = (Integer)exchange.getIn().getHeader("JGROUPSRAFT_SET_OFFSET", Integer.class);
        Integer setLength = (Integer)exchange.getIn().getHeader("JGROUPSRAFT_SET_LENGTH", Integer.class);
        Long setTimeout = (Long)exchange.getIn().getHeader("JGROUPSRAFT_SET_TIMEOUT", Long.class);
        TimeUnit setTimeUnit = (TimeUnit)((Object)exchange.getIn().getHeader("JGROUPSRAFT_SET_TIMEUNIT", TimeUnit.class));
        if (body != null) {
            byte[] result;
            if (setOffset != null && setLength != null && setTimeout != null && setTimeUnit != null) {
                this.log.debug("Calling set(byte[] {}, int {}, int {}, long {}, TimeUnit {}) method on raftHandle.", new Object[]{body, setOffset, setLength, setTimeout, setTimeUnit});
                result = this.raftHandle.set(body, setOffset.intValue(), setLength.intValue(), setTimeout.longValue(), setTimeUnit);
            } else if (setOffset != null && setLength != null) {
                this.log.debug("Calling set(byte[] {}, int {}, int {}) method on raftHandle.", new Object[]{body, setOffset, setLength});
                result = this.raftHandle.set(body, setOffset.intValue(), setLength.intValue());
            } else {
                this.log.debug("Calling set(byte[] {}, int {}, int {} (i.e. body.length)) method on raftHandle.", new Object[]{body, 0, body.length});
                result = this.raftHandle.set(body, 0, body.length);
            }
            this.endpoint.populateJGroupsRaftHeaders(exchange);
            exchange.getIn().setBody((Object)result);
        } else {
            this.log.debug("Body is null, cannot call set method on raftHandle.");
        }
    }
}

