/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.ahc.ws.WsEndpoint;
import org.apache.camel.support.DefaultConsumer;

public class WsConsumer
extends DefaultConsumer {
    public WsConsumer(WsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public void start() throws Exception {
        super.start();
        this.getEndpoint().connect(this);
    }

    public void stop() throws Exception {
        this.getEndpoint().disconnect(this);
        super.stop();
    }

    public WsEndpoint getEndpoint() {
        return (WsEndpoint)super.getEndpoint();
    }

    public void sendMessage(String message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(Throwable throwable) {
        this.sendMessageInternal(throwable);
    }

    public void sendMessage(byte[] message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(InputStream message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(Reader message) {
        this.sendMessageInternal(message);
    }

    private void sendMessageInternal(Object message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        if (message instanceof Throwable) {
            exchange.setException((Throwable)message);
        } else {
            exchange.getIn().setBody(message);
        }
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WsConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }
}

