/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes;

import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class KubernetesNodesProducer
extends DefaultProducer {
    public KubernetesNodesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listNodes": {
                this.doList(exchange, operation);
                break;
            }
            case "listNodesByLabels": {
                this.doListNodesByLabels(exchange, operation);
                break;
            }
            case "getNode": {
                this.doGetNode(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        NodeList nodeList = (NodeList)this.getEndpoint().getKubernetesClient().nodes().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)nodeList.getItems());
    }

    protected void doListNodesByLabels(Exchange exchange, String operation) throws Exception {
        NodeList nodeList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNodesLabels", Map.class);
        NonNamespaceOperation nodes = this.getEndpoint().getKubernetesClient().nodes();
        for (Map.Entry entry : labels.entrySet()) {
            nodes.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        nodeList = (NodeList)nodes.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)nodeList.getItems());
    }

    protected void doGetNode(Exchange exchange, String operation) throws Exception {
        Node node = null;
        String pvName = (String)exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        if (ObjectHelper.isEmpty((Object)pvName)) {
            this.log.error("Get a specific Node require specify a Node name");
            throw new IllegalArgumentException("Get a specific Node require specify a Node name");
        }
        node = (Node)((Resource)this.getEndpoint().getKubernetesClient().nodes().withName(pvName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)node);
    }
}

