/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import com.lmax.disruptor.InsufficientCapacityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.disruptor.DisruptorComponent;
import org.apache.camel.component.disruptor.DisruptorConsumer;
import org.apache.camel.component.disruptor.DisruptorNotStartedException;
import org.apache.camel.component.disruptor.DisruptorProducer;
import org.apache.camel.component.disruptor.DisruptorProducerType;
import org.apache.camel.component.disruptor.DisruptorReference;
import org.apache.camel.component.disruptor.DisruptorWaitStrategy;
import org.apache.camel.component.disruptor.LifecycleAwareExchangeEventHandler;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Disruptor Endpoint")
@UriEndpoint(firstVersion="2.12.0", scheme="disruptor,disruptor-vm", title="Disruptor,Disruptor VM", syntax="disruptor:name", label="endpoint")
public class DisruptorEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
MultipleConsumersSupport {
    public static final String DISRUPTOR_IGNORE_EXCHANGE = "disruptor.ignoreExchange";
    private static final Logger LOGGER = LoggerFactory.getLogger(DisruptorEndpoint.class);
    private final Set<DisruptorProducer> producers = new CopyOnWriteArraySet<DisruptorProducer>();
    private final Set<DisruptorConsumer> consumers = new CopyOnWriteArraySet<DisruptorConsumer>();
    private final DisruptorReference disruptorReference;
    @UriPath(description="Name of queue")
    @Metadata(required=true)
    private String name;
    @UriParam(label="consumer", defaultValue="1")
    private final int concurrentConsumers;
    @UriParam(label="consumer")
    private final boolean multipleConsumers;
    @UriParam(label="producer", defaultValue="IfReplyExpected")
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;
    @UriParam(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @UriParam(defaultValue="1024")
    private int size;
    @UriParam(label="producer")
    private boolean blockWhenFull;
    @UriParam(label="consumer", defaultValue="Blocking")
    private DisruptorWaitStrategy waitStrategy;
    @UriParam(label="producer", defaultValue="Multi")
    private DisruptorProducerType producerType;

    public DisruptorEndpoint(String endpointUri, Component component, DisruptorReference disruptorReference, int concurrentConsumers, boolean multipleConsumers, boolean blockWhenFull) throws Exception {
        super(endpointUri, component);
        this.disruptorReference = disruptorReference;
        this.name = disruptorReference.getName();
        this.concurrentConsumers = concurrentConsumers;
        this.multipleConsumers = multipleConsumers;
        this.blockWhenFull = blockWhenFull;
    }

    @ManagedAttribute(description="Queue name")
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Buffer max capacity")
    public int getBufferSize() {
        return this.disruptorReference.getBufferSize();
    }

    @ManagedAttribute(description="Remaining capacity in ring buffer")
    public long getRemainingCapacity() throws DisruptorNotStartedException {
        return this.getDisruptor().getRemainingCapacity();
    }

    @ManagedAttribute(description="Amount of pending exchanges waiting for consumption in ring buffer")
    public long getPendingExchangeCount() throws DisruptorNotStartedException {
        return this.getDisruptor().getPendingExchangeCount();
    }

    @ManagedAttribute(description="Number of concurrent consumers")
    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    @ManagedAttribute(description="Option to specify whether the caller should wait for the async task to complete or not before continuing")
    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    @ManagedAttribute(description="Timeout (in milliseconds) before a producer will stop waiting for an asynchronous task to complete")
    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @ManagedAttribute(description="The maximum capacity of the Disruptors ringbuffer")
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @ManagedAttribute(description="Specifies whether multiple consumers are allowed")
    public boolean isMultipleConsumersSupported() {
        return this.isMultipleConsumers();
    }

    public boolean isMultipleConsumers() {
        return this.multipleConsumers;
    }

    public Set<DisruptorConsumer> getConsumers() {
        return Collections.unmodifiableSet(this.consumers);
    }

    public Set<DisruptorProducer> getProducers() {
        return Collections.unmodifiableSet(this.producers);
    }

    @ManagedAttribute
    public boolean isBlockWhenFull() {
        return this.blockWhenFull;
    }

    public void setBlockWhenFull(boolean blockWhenFull) {
        this.blockWhenFull = blockWhenFull;
    }

    @ManagedAttribute(description="Defines the strategy used by consumer threads to wait on new exchanges to be published")
    public DisruptorWaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(DisruptorWaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    @ManagedAttribute(description=" Defines the producers allowed on the Disruptor")
    public DisruptorProducerType getProducerType() {
        return this.producerType;
    }

    public void setProducerType(DisruptorProducerType producerType) {
        this.producerType = producerType;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        if (this.getProducers().size() == 1 && this.getDisruptor().getProducerType() == DisruptorProducerType.Single) {
            throw new IllegalStateException("Endpoint can't support multiple producers when ProducerType SINGLE is configured");
        }
        return new DisruptorProducer(this, this.getWaitForTaskToComplete(), this.getTimeout(), this.isBlockWhenFull());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DisruptorConsumer(this, processor);
    }

    protected void doStart() throws Exception {
        this.disruptorReference.addEndpoint(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.disruptorReference.removeEndpoint(this);
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        if (this.getComponent() != null) {
            this.getComponent().onShutdownEndpoint(this);
        }
        super.doShutdown();
    }

    public DisruptorComponent getComponent() {
        return (DisruptorComponent)super.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStarted(DisruptorConsumer consumer) throws Exception {
        DisruptorEndpoint disruptorEndpoint = this;
        synchronized (disruptorEndpoint) {
            if (!this.consumers.isEmpty() && !this.isMultipleConsumersSupported()) {
                throw new IllegalStateException("Multiple consumers for the same endpoint is not allowed: " + (Object)((Object)this));
            }
            if (this.consumers.add(consumer)) {
                LOGGER.debug("Starting consumer {} on endpoint {}", (Object)consumer, (Object)this.getEndpointUri());
                this.getDisruptor().reconfigure();
            } else {
                LOGGER.debug("Tried to start Consumer {} on endpoint {} but it was already started", (Object)consumer, (Object)this.getEndpointUri());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStopped(DisruptorConsumer consumer) throws Exception {
        DisruptorEndpoint disruptorEndpoint = this;
        synchronized (disruptorEndpoint) {
            if (this.consumers.remove((Object)consumer)) {
                LOGGER.debug("Stopping consumer {} on endpoint {}", (Object)consumer, (Object)this.getEndpointUri());
                this.getDisruptor().reconfigure();
            } else {
                LOGGER.debug("Tried to stop Consumer {} on endpoint {} but it was already stopped", (Object)consumer, (Object)this.getEndpointUri());
            }
        }
    }

    void onStarted(DisruptorProducer producer) {
        this.producers.add(producer);
    }

    void onStopped(DisruptorProducer producer) {
        this.producers.remove((Object)producer);
    }

    Map<DisruptorConsumer, Collection<LifecycleAwareExchangeEventHandler>> createConsumerEventHandlers() {
        HashMap<DisruptorConsumer, Collection<LifecycleAwareExchangeEventHandler>> result = new HashMap<DisruptorConsumer, Collection<LifecycleAwareExchangeEventHandler>>();
        for (DisruptorConsumer consumer : this.consumers) {
            result.put(consumer, consumer.createEventHandlers(this.concurrentConsumers));
        }
        return result;
    }

    void publish(Exchange exchange) throws DisruptorNotStartedException {
        this.disruptorReference.publish(exchange);
    }

    void tryPublish(Exchange exchange) throws DisruptorNotStartedException, InsufficientCapacityException {
        this.disruptorReference.tryPublish(exchange);
    }

    DisruptorReference getDisruptor() {
        return this.disruptorReference;
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        return result && this.getCamelContext().equals(((DisruptorEndpoint)((Object)object)).getCamelContext());
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + this.getCamelContext().hashCode();
    }
}

