/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.TelegramServiceProvider;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.support.DefaultProducer;

public class TelegramProducer
extends DefaultProducer {
    private TelegramEndpoint endpoint;

    public TelegramProducer(TelegramEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getIn().getBody() == null) {
            this.log.debug("Received exchange with empty body, skipping");
            return;
        }
        TelegramConfiguration config = this.endpoint.getConfiguration();
        OutgoingMessage message = (OutgoingMessage)exchange.getIn().getBody(OutgoingMessage.class);
        if (message == null) {
            throw new IllegalArgumentException("Cannot convert the content to a Telegram OutgoingMessage");
        }
        if (message.getChatId() == null) {
            this.log.debug("Chat id is null on outgoing message, trying resolution");
            String chatId = this.resolveChatId(config, message, exchange);
            this.log.debug("Resolved chat id is {}", (Object)chatId);
            message.setChatId(chatId);
        }
        TelegramService service = TelegramServiceProvider.get().getService();
        this.log.debug("Message being sent is: {}", (Object)message);
        this.log.debug("Headers of message being sent are: {}", (Object)exchange.getIn().getHeaders());
        Object receivedMessage = service.sendMessage(config.getAuthorizationToken(), message);
        this.log.debug("Message being received is: {}", receivedMessage);
        exchange.getOut().setBody(receivedMessage);
    }

    private String resolveChatId(TelegramConfiguration config, OutgoingMessage message, Exchange exchange) {
        String chatId = message.getChatId();
        if (chatId == null) {
            chatId = (String)exchange.getIn().getHeader("CamelTelegramChatId");
        }
        if (chatId == null) {
            chatId = config.getChatId();
        }
        if (chatId == null) {
            throw new IllegalStateException("Chat id is not set in message headers or route configuration");
        }
        return chatId;
    }
}

