/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.inject.Named;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consume;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TypeConverter;
import org.apache.camel.cdi.AnnotatedMethodDelegate;
import org.apache.camel.cdi.AnnotatedTypeDelegate;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.ApplicationScopedLiteral;
import org.apache.camel.cdi.BeanDelegate;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.CamelBeanInjectionTarget;
import org.apache.camel.cdi.CdiCamelConfigurationEvent;
import org.apache.camel.cdi.CdiCamelEnvironment;
import org.apache.camel.cdi.CdiCamelFactory;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.CdiTypeConverterLoader;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Excluded;
import org.apache.camel.cdi.ForwardingObserverMethod;
import org.apache.camel.cdi.ImportResource;
import org.apache.camel.cdi.ResourceHelper;
import org.apache.camel.cdi.Startup;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.cdi.SyntheticInjectionTarget;
import org.apache.camel.cdi.Uri;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.cdi.XmlCdiBeanFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.spi.CamelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiCamelExtension
implements Extension {
    private final Logger logger = LoggerFactory.getLogger(CdiCamelExtension.class);
    private final CdiCamelEnvironment environment = new CdiCamelEnvironment();
    private final Set<Class<?>> converters = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> camelBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> eagerBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, CdiEventEndpoint<?>> cdiEventEndpoints = new ConcurrentHashMap();
    private final Set<Bean<?>> cdiBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Annotation> contextQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Method, Bean<?>> producerBeans = new ConcurrentHashMap();
    private final Map<Method, Set<Annotation>> producerQualifiers = new ConcurrentHashMap<Method, Set<Annotation>>();
    private final Set<Annotation> eventQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<AnnotatedType<?>, ImportResource> resources = new ConcurrentHashMap();
    private final CdiCamelConfigurationEvent configuration = new CdiCamelConfigurationEvent();

    CdiEventEndpoint<?> getEventEndpoint(String uri) {
        return this.cdiEventEndpoints.get(uri);
    }

    Set<Annotation> getObserverEvents() {
        return this.eventQualifiers;
    }

    Set<Annotation> getContextQualifiers() {
        return this.contextQualifiers;
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(Vetoed.class)) {
            pat.veto();
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Converter.class)) {
            this.converters.add(pat.getAnnotatedType().getJavaClass());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), BeanInject.class, Consume.class, EndpointInject.class, Produce.class, PropertyInject.class)) {
            this.camelBeans.add(pat.getAnnotatedType());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Consume.class)) {
            this.eagerBeans.add(pat.getAnnotatedType());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), ImportResource.class)) {
            this.resources.put(pat.getAnnotatedType(), (ImportResource)pat.getAnnotatedType().getAnnotation(ImportResource.class));
        }
    }

    private <T extends CamelContext> void camelContextBeans(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(this.environment.camelContextInjectionTarget(pit.getInjectionTarget(), (Annotated)pit.getAnnotatedType(), manager, this));
    }

    private <T extends CamelContext> void camelContextProducers(@Observes ProcessProducer<?, T> pp, BeanManager manager) {
        pp.setProducer(this.environment.camelContextProducer(pp.getProducer(), (Annotated)pp.getAnnotatedMember(), manager, this));
    }

    private <T> void camelBeansPostProcessor(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        if (this.camelBeans.contains(pit.getAnnotatedType())) {
            pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
        }
    }

    private <T extends CamelContextAware> void camelContextAware(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
    }

    private <T extends Endpoint> void endpointBeans(@Observes ProcessProducerMethod<T, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void consumerTemplateBeans(@Observes ProcessProducerMethod<ConsumerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void producerTemplateBeans(@Observes ProcessProducerMethod<ProducerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void fluentProducerTemplateBeans(@Observes ProcessProducerMethod<FluentProducerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void camelFactoryProducers(@Observes ProcessAnnotatedType<CdiCamelFactory> pat, BeanManager manager) {
        pat.setAnnotatedType(new AnnotatedTypeDelegate(pat.getAnnotatedType(), pat.getAnnotatedType().getMethods().stream().filter(am -> am.isAnnotationPresent(Produces.class)).filter(am -> am.getTypeClosure().stream().noneMatch(Predicate.isEqual(TypeConverter.class))).peek(am -> this.producerQualifiers.put(am.getJavaMember(), CdiSpiHelper.getQualifiers((Annotated)am, manager))).map(am -> new AnnotatedMethodDelegate(am, (Set<Annotation>)am.getAnnotations().stream().filter(annotation -> !manager.isQualifier(annotation.annotationType())).collect(Collectors.collectingAndThen(Collectors.toSet(), annotations -> {
            annotations.add(Excluded.EXCLUDED);
            return annotations;
        })))).collect(Collectors.toSet())));
    }

    private <T extends CamelEvent> void camelEventNotifiers(@Observes ProcessObserverMethod<T, ?> pom) {
        Type type = pom.getObserverMethod().getObservedType();
        if (type instanceof Class && CamelEvent.class.isAssignableFrom((Class)Class.class.cast(type))) {
            Set qualifiers = pom.getObserverMethod().getObservedQualifiers();
            if (qualifiers.isEmpty()) {
                this.eventQualifiers.add((Annotation)AnyLiteral.ANY);
            } else if (qualifiers.size() == 1 && qualifiers.stream().anyMatch(CdiSpiHelper.isAnnotationType(Named.class))) {
                this.eventQualifiers.add((Annotation)DefaultLiteral.DEFAULT);
            } else {
                this.eventQualifiers.addAll(qualifiers);
            }
        }
    }

    private void beans(@Observes ProcessProducerField<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessProducerMethod<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessBean<?> pb, BeanManager manager) {
        this.cdiBeans.add(pb.getBean());
        pb.getBean().getInjectionPoints().stream().filter(ip -> CdiEventEndpoint.class.equals(CdiSpiHelper.getRawType(ip.getType()))).forEach(ip -> {
            Class<Object> type = ip.getType() instanceof ParameterizedType ? ((ParameterizedType)ip.getType()).getActualTypeArguments()[0] : Object.class;
            String uri = CdiEventEndpoint.eventEndpointUri(type, ip.getQualifiers());
            this.cdiEventEndpoints.put(uri, new CdiEventEndpoint(uri, (Type)((Object)type), ip.getQualifiers(), manager));
        });
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        Bean context;
        HashSet extraBeans = new HashSet();
        for (AnnotatedType<?> annotatedType : this.resources.keySet()) {
            XmlCdiBeanFactory factory = XmlCdiBeanFactory.with(manager, this.environment, this);
            ImportResource resource = this.resources.get(annotatedType);
            for (String path : resource.value()) {
                try {
                    extraBeans.addAll(factory.beansFrom(path, annotatedType));
                }
                catch (NoClassDefFoundError cause) {
                    if (cause.getMessage().contains("AbstractCamelContextFactoryBean")) {
                        this.logger.error("Importing Camel XML requires to have the 'camel-core-xml' dependency in the classpath!");
                    }
                    throw cause;
                }
                catch (Exception cause) {
                    abd.addDefinitionError((Throwable)new InjectionException("Error while importing resource [" + ResourceHelper.getResource(path, annotatedType.getJavaClass().getClassLoader()) + "]", (Throwable)cause));
                }
            }
        }
        Stream.concat(this.cdiBeans.stream(), extraBeans.stream()).filter(CdiSpiHelper.hasType(CamelContext.class)).map(Bean::getQualifiers).forEach(this.contextQualifiers::addAll);
        List routeBeans = this.cdiBeans.stream().filter(CdiSpiHelper.hasType(RoutesBuilder.class).or(CdiSpiHelper.hasType(RouteContainer.class))).filter(bean -> bean.getQualifiers().stream().filter(CdiSpiHelper.isAnnotationType(ContextName.class).and(name -> !this.contextQualifiers.contains(name))).peek(this.contextQualifiers::add).count() > 0L).collect(Collectors.toList());
        for (Bean bean2 : routeBeans) {
            Optional<Annotation> annotation = bean2.getQualifiers().stream().filter(CdiSpiHelper.isAnnotationType(ContextName.class)).findFirst();
            extraBeans.add(this.camelContextBean(manager, bean2.getBeanClass(), new Annotation[]{AnyLiteral.ANY, annotation.get(), ApplicationScopedLiteral.APPLICATION_SCOPED}));
        }
        Set<Bean<?>> set = Stream.concat(this.cdiBeans.stream(), extraBeans.stream()).collect(Collectors.toSet());
        Set contexts = set.stream().filter(CdiSpiHelper.hasType(CamelContext.class)).collect(Collectors.toSet());
        if (contexts.size() == 0 && this.shouldDeployDefaultCamelContext(set)) {
            extraBeans.add(this.camelContextBean(manager, null, new Annotation[]{AnyLiteral.ANY, DefaultLiteral.DEFAULT, ApplicationScopedLiteral.APPLICATION_SCOPED}));
        } else if (contexts.size() == 1 && !(context = (Bean)contexts.iterator().next()).getQualifiers().contains(DefaultLiteral.DEFAULT) && context instanceof SyntheticBean) {
            ((SyntheticBean)context).addQualifier(DefaultLiteral.DEFAULT);
        }
        extraBeans.forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        Set endpointQualifiers = this.cdiEventEndpoints.values().stream().map(CdiEventEndpoint::getQualifiers).flatMap(Collection::stream).collect(Collectors.toSet());
        Set templateQualifiers = this.contextQualifiers.stream().filter(CdiSpiHelper.isAnnotationType(Default.class).or(CdiSpiHelper.isAnnotationType(Named.class)).negate()).collect(Collectors.toSet());
        this.producerBeans.entrySet().stream().map(producer -> new BeanDelegate((Bean)producer.getValue(), this.producerQualifiers.get(producer.getKey()), CdiEventEndpoint.class.equals(((Method)producer.getKey()).getReturnType()) ? endpointQualifiers : templateQualifiers)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        this.cdiEventEndpoints.values().stream().map(ForwardingObserverMethod::new).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addObserverMethod(arg_0));
    }

    private boolean shouldDeployDefaultCamelContext(Set<Bean<?>> beans) {
        return beans.stream().filter(bean -> !bean.getBeanClass().getPackage().equals(this.getClass().getPackage())).filter(CdiSpiHelper.hasType(CamelContextAware.class).or(CdiSpiHelper.hasType(Component.class)).or(CdiSpiHelper.hasType(RouteContainer.class).or(CdiSpiHelper.hasType(RoutesBuilder.class)))).map(Bean::getQualifiers).flatMap(Collection::stream).anyMatch(Predicate.isEqual(DefaultLiteral.DEFAULT)) || Stream.concat(this.camelBeans.stream().map(AnnotatedType::getFields), this.camelBeans.stream().map(AnnotatedType::getMethods)).flatMap(Collection::stream).map(Annotated::getAnnotations).flatMap(Collection::stream).anyMatch(CdiSpiHelper.isAnnotationType(Consume.class).and(a -> ((Consume)a).context().isEmpty()).or(CdiSpiHelper.isAnnotationType(BeanInject.class).and(a -> ((BeanInject)a).context().isEmpty())).or(CdiSpiHelper.isAnnotationType(EndpointInject.class).and(a -> ((EndpointInject)a).context().isEmpty())).or(CdiSpiHelper.isAnnotationType(Produce.class).and(a -> ((Produce)a).context().isEmpty())).or(CdiSpiHelper.isAnnotationType(PropertyInject.class).and(a -> ((PropertyInject)a).context().isEmpty()))) || beans.stream().filter(bean -> !bean.getBeanClass().getPackage().equals(this.getClass().getPackage())).map(Bean::getInjectionPoints).flatMap(Collection::stream).filter(ip -> CdiSpiHelper.getRawType(ip.getType()).getName().startsWith("org.apache.camel")).map(InjectionPoint::getQualifiers).flatMap(Collection::stream).anyMatch(CdiSpiHelper.isAnnotationType(Uri.class).or(Predicate.isEqual(DefaultLiteral.DEFAULT)));
    }

    private SyntheticBean<?> camelContextBean(BeanManager manager, Class<?> beanClass, Annotation ... qualifiers) {
        SyntheticAnnotated annotated = new SyntheticAnnotated(DefaultCamelContext.class, (Set<Type>)manager.createAnnotatedType(DefaultCamelContext.class).getTypeClosure(), beanClass, qualifiers);
        return new SyntheticBean<DefaultCamelContext>(manager, annotated, DefaultCamelContext.class, this.environment.camelContextInjectionTarget(new SyntheticInjectionTarget<DefaultCamelContext>(DefaultCamelContext::new), annotated, manager, this), bean -> "Default Camel context bean with qualifiers " + bean.getQualifiers());
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        manager.fireEvent((Object)this.configuration, new Annotation[0]);
        this.configuration.unmodifiable();
        ArrayList<CamelContext> contexts = new ArrayList<CamelContext>();
        for (Bean bean2 : manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.ANY})) {
            contexts.add(BeanManagerHelper.getReference(manager, CamelContext.class, bean2));
        }
        for (CamelContext camelContext : contexts) {
            CdiTypeConverterLoader loader = new CdiTypeConverterLoader();
            for (Class<?> converter : this.converters) {
                loader.loadConverterMethods(camelContext.getTypeConverterRegistry(), converter);
            }
        }
        if (this.configuration.autoConfigureRoutes()) {
            boolean deploymentException = false;
            HashSet hashSet = new HashSet(manager.getBeans(RoutesBuilder.class, new Annotation[]{AnyLiteral.ANY}));
            hashSet.addAll(manager.getBeans(RouteContainer.class, new Annotation[]{AnyLiteral.ANY}));
            for (Bean context : manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.ANY})) {
                for (Bean route : hashSet) {
                    HashSet qualifiers = new HashSet(context.getQualifiers());
                    qualifiers.retainAll(route.getQualifiers());
                    if (qualifiers.size() <= 1) continue;
                    deploymentException |= !this.addRouteToContext(route, context, manager, adv);
                }
            }
            if (deploymentException) {
                return;
            }
        }
        this.eagerBeans.forEach(type -> BeanManagerHelper.getReferencesByType(manager, type.getJavaClass(), new Annotation[]{AnyLiteral.ANY}).toString());
        manager.getBeans(Object.class, new Annotation[]{AnyLiteral.ANY, Startup.Literal.STARTUP}).forEach(bean -> BeanManagerHelper.getReference(manager, bean.getBeanClass(), bean).toString());
        if (this.configuration.autoStartContexts()) {
            for (CamelContext camelContext : contexts) {
                if (ServiceStatus.Started.equals((Object)camelContext.getStatus())) continue;
                this.logger.info("Camel CDI is starting Camel context [{}]", (Object)camelContext.getName());
                try {
                    camelContext.start();
                }
                catch (Exception exception) {
                    adv.addDeploymentProblem((Throwable)exception);
                }
            }
        }
        Stream.of(this.converters, this.camelBeans, this.eagerBeans, this.cdiBeans).forEach(Set::clear);
        Stream.of(this.producerBeans, this.producerQualifiers).forEach(Map::clear);
    }

    private boolean addRouteToContext(Bean<?> routeBean, Bean<?> contextBean, BeanManager manager, AfterDeploymentValidation adv) {
        try {
            CamelContext context = BeanManagerHelper.getReference(manager, CamelContext.class, contextBean);
            try {
                Object route = BeanManagerHelper.getReference(manager, Object.class, routeBean);
                if (route instanceof RoutesBuilder) {
                    context.addRoutes((RoutesBuilder)route);
                } else if (route instanceof RouteContainer) {
                    ((ModelCamelContext)context.adapt(ModelCamelContext.class)).addRouteDefinitions((Collection)((RouteContainer)route).getRoutes());
                } else {
                    throw new IllegalArgumentException("Invalid routes type [" + routeBean.getBeanClass().getName() + "], must be either of type RoutesBuilder or RouteContainer!");
                }
                return true;
            }
            catch (Exception cause) {
                adv.addDeploymentProblem((Throwable)new InjectionException("Error adding routes of type [" + routeBean.getBeanClass().getName() + "] to Camel context [" + context.getName() + "]", (Throwable)cause));
            }
        }
        catch (Exception exception) {
            adv.addDeploymentProblem((Throwable)exception);
        }
        return false;
    }
}

