/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Named;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.CdiCamelBeanRepository;
import org.apache.camel.cdi.CdiCamelContextNameStrategy;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.cdi.CdiCamelInjector;
import org.apache.camel.cdi.CdiEventNotifier;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.DelegateProducer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CamelContextProducer<T extends CamelContext>
extends DelegateProducer<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Annotated annotated;
    private final BeanManager manager;
    private final CdiCamelExtension extension;

    CamelContextProducer(Producer<T> delegate, Annotated annotated, BeanManager manager, CdiCamelExtension extension) {
        super(delegate);
        this.annotated = annotated;
        this.manager = manager;
        this.extension = extension;
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        CamelContext context = CdiSpiHelper.createCamelContextWithTCCL(() -> (CamelContext)super.produce(ctx), this.annotated);
        if (context.getNameStrategy() instanceof DefaultCamelContextNameStrategy) {
            context.setNameStrategy(CamelContextProducer.nameStrategy(this.annotated));
        }
        if (!(context instanceof DefaultCamelContext)) {
            throw new InjectionException("Camel CDI requires Camel context [" + context.getName() + "] to be a subtype of DefaultCamelContext");
        }
        DefaultCamelContext adapted = (DefaultCamelContext)context.adapt(DefaultCamelContext.class);
        adapted.setRegistry((Registry)new DefaultRegistry(new BeanRepository[]{new CdiCamelBeanRepository(this.manager)}));
        adapted.setInjector((Injector)new CdiCamelInjector(context.getInjector(), this.manager));
        Set<Annotation> qualifiers = this.annotated.getAnnotations().stream().filter(CdiSpiHelper.isAnnotationType(Named.class).negate().and(q -> this.manager.isQualifier(q.annotationType()))).collect(Collectors.toSet());
        qualifiers.add((Annotation)AnyLiteral.ANY);
        if (qualifiers.size() == 1) {
            qualifiers.add((Annotation)DefaultLiteral.DEFAULT);
        }
        qualifiers.retainAll(this.extension.getObserverEvents());
        if (!qualifiers.isEmpty()) {
            context.getManagementStrategy().addEventNotifier((EventNotifier)new CdiEventNotifier(this.manager, qualifiers));
        }
        return (T)context;
    }

    @Override
    public void dispose(T context) {
        super.dispose(context);
        if (!context.getStatus().isStopped()) {
            this.logger.info("Camel CDI is stopping Camel context [{}]", (Object)context.getName());
            try {
                context.stop();
            }
            catch (Exception cause) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)cause);
            }
        }
    }

    private static CamelContextNameStrategy nameStrategy(Annotated annotated) {
        if (annotated.isAnnotationPresent(ContextName.class)) {
            return new ExplicitCamelContextNameStrategy(((ContextName)annotated.getAnnotation(ContextName.class)).value());
        }
        if (annotated.isAnnotationPresent(Named.class)) {
            String name = ((Named)annotated.getAnnotation(Named.class)).value();
            if (name.isEmpty()) {
                if (annotated instanceof AnnotatedField) {
                    name = ((AnnotatedField)annotated).getJavaMember().getName();
                } else if (annotated instanceof AnnotatedMethod) {
                    name = ((AnnotatedMethod)annotated).getJavaMember().getName();
                    if (name.startsWith("get")) {
                        name = Introspector.decapitalize(name.substring(3));
                    }
                } else {
                    name = Introspector.decapitalize(CdiSpiHelper.getRawType(annotated.getBaseType()).getSimpleName());
                }
            }
            return new ExplicitCamelContextNameStrategy(name);
        }
        return new CdiCamelContextNameStrategy();
    }
}

