/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.lumberjack.LumberjackComponent;
import org.apache.camel.component.lumberjack.LumberjackConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriEndpoint(firstVersion="2.18.0", scheme="lumberjack", title="Lumberjack", syntax="lumberjack:host:port", consumerOnly=true, label="log")
public class LumberjackEndpoint
extends DefaultEndpoint {
    @UriPath(description="Network interface on which to listen for Lumberjack")
    @Metadata(required=true)
    private final String host;
    @UriPath(description="Network port on which to listen for Lumberjack", defaultValue="5044")
    private final int port;
    @UriParam(description="SSL configuration")
    private SSLContextParameters sslContextParameters;

    LumberjackEndpoint(String endpointUri, LumberjackComponent component, String host, int port) {
        super(endpointUri, (Component)component);
        this.host = host;
        this.port = port;
    }

    public LumberjackComponent getComponent() {
        return (LumberjackComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The Lumberjack component cannot be used as a producer");
    }

    public LumberjackConsumer createConsumer(Processor processor) throws Exception {
        return new LumberjackConsumer(this, processor, this.host, this.port, this.provideSSLContext());
    }

    public boolean isSingleton() {
        return true;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    private SSLContext provideSSLContext() throws GeneralSecurityException, IOException {
        if (this.sslContextParameters != null) {
            return this.sslContextParameters.createSSLContext(this.getCamelContext());
        }
        if (this.getComponent().getSslContextParameters() != null) {
            return this.getComponent().getSslContextParameters().createSSLContext(this.getCamelContext());
        }
        return null;
    }
}

