/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NonBlockingNagiosPassiveCheckSender;
import com.googlecode.jsendnsca.PassiveCheckSender;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nagios.NagiosConfiguration;
import org.apache.camel.component.nagios.NagiosProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.3.0", scheme="nagios", title="Nagios", syntax="nagios:host:port", producerOnly=true, label="monitoring")
public class NagiosEndpoint
extends DefaultEndpoint {
    private PassiveCheckSender sender;
    @UriParam
    private NagiosConfiguration configuration;
    @UriParam(defaultValue="true")
    private boolean sendSync = true;

    public NagiosEndpoint() {
    }

    public NagiosEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        return new NagiosProducer(this, this.getSender());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Nagios consumer not supported");
    }

    public boolean isSingleton() {
        return true;
    }

    public NagiosConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NagiosConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isSendSync() {
        return this.sendSync;
    }

    public void setSendSync(boolean sendSync) {
        this.sendSync = sendSync;
    }

    public synchronized PassiveCheckSender getSender() {
        if (this.sender == null) {
            this.sender = this.isSendSync() ? new NagiosPassiveCheckSender(this.getConfiguration().getNagiosSettings()) : new NonBlockingNagiosPassiveCheckSender(this.getConfiguration().getNagiosSettings());
        }
        return this.sender;
    }

    public void setSender(PassiveCheckSender sender) {
        this.sender = sender;
    }
}

