/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.linkedin.DefaultOAuthSecureStorage;
import org.apache.camel.component.linkedin.LinkedInConfiguration;
import org.apache.camel.component.linkedin.LinkedInEndpoint;
import org.apache.camel.component.linkedin.api.LinkedInOAuthRequestFilter;
import org.apache.camel.component.linkedin.api.OAuthParams;
import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.internal.CachingOAuthSecureStorage;
import org.apache.camel.component.linkedin.internal.LinkedInApiCollection;
import org.apache.camel.component.linkedin.internal.LinkedInApiName;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

@Component(value="linkedin")
public class LinkedInComponent
extends AbstractApiComponent<LinkedInApiName, LinkedInConfiguration, LinkedInApiCollection> {
    private LinkedInOAuthRequestFilter requestFilter;

    public LinkedInComponent() {
        super(LinkedInEndpoint.class, LinkedInApiName.class, (ApiCollection)LinkedInApiCollection.getCollection());
    }

    public LinkedInComponent(CamelContext context) {
        super(context, LinkedInEndpoint.class, LinkedInApiName.class, (ApiCollection)LinkedInApiCollection.getCollection());
    }

    protected LinkedInApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return LinkedInApiName.fromValue(apiNameStr);
    }

    public void setConfiguration(LinkedInConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public LinkedInConfiguration getConfiguration() {
        return (LinkedInConfiguration)super.getConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String methodName, LinkedInApiName apiName, LinkedInConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new LinkedInEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public synchronized LinkedInOAuthRequestFilter getRequestFilter(LinkedInConfiguration endpointConfiguration) {
        if (endpointConfiguration.equals(this.configuration)) {
            if (this.requestFilter == null) {
                this.requestFilter = this.createRequestFilter((LinkedInConfiguration)this.configuration);
            }
            return this.requestFilter;
        }
        return this.createRequestFilter(endpointConfiguration);
    }

    private LinkedInOAuthRequestFilter createRequestFilter(LinkedInConfiguration configuration) {
        String[] enabledProtocols;
        configuration.validate();
        try {
            SSLContext sslContext = new SSLContextParameters().createSSLContext(this.getCamelContext());
            enabledProtocols = sslContext.createSSLEngine().getEnabledProtocols();
        }
        catch (GeneralSecurityException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        catch (IOException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return new LinkedInOAuthRequestFilter(LinkedInComponent.getOAuthParams(configuration), configuration.getHttpParams(), configuration.isLazyAuth(), enabledProtocols);
    }

    private static OAuthParams getOAuthParams(LinkedInConfiguration configuration) {
        OAuthSecureStorage secureStorage = configuration.getSecureStorage();
        if (secureStorage == null && !ObjectHelper.isEmpty((Object)configuration.getAccessToken())) {
            secureStorage = new DefaultOAuthSecureStorage(configuration.getAccessToken(), configuration.getExpiryTime());
        }
        return new OAuthParams(configuration.getUserName(), configuration.getUserPassword(), (OAuthSecureStorage)new CachingOAuthSecureStorage(secureStorage), configuration.getClientId(), configuration.getClientSecret(), configuration.getRedirectUri(), configuration.getScopes());
    }
}

